% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-Transferable.R
\name{Transferable}
\alias{Transferable}
\alias{Biomass-transfer}
\alias{Transferable-class}
\title{Biomass transfer class}
\description{
By inheriting from class \code{Transferable}, a scenario's behavior can be
extended to support transfer and reset of biomass at dedicated points during
simulation.
}
\section{Slots}{

\describe{
\item{\code{transfer.times}}{\code{numeric}, vector of time points at which transfers occur,
e.g. \code{c(7,10,14)}}

\item{\code{transfer.interval}}{\code{numeric}, interval length until frond transfer to new
medium}

\item{\code{transfer.biomass}}{\code{numeric}, amount of biomass transferred to new medium}

\item{\code{transfer.comp.biomass}}{\code{character} state variable which describes
biomass}

\item{\code{transfer.comp.scaled}}{\code{character} vector of state variable which will
be scaled 1:1 when biomass is modified, e.g. internal toxicant mass}
}}

\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. Lemna effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

Any transfer time point must also be an output time point. If a transfer
occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that in order to use transfers at regular
intervals, the simulation must start at time point zero.
}

\seealso{
\code{\link[=set_transfer]{set_transfer()}}

Other scenarios: 
\code{\link{Algae-models}},
\code{\link{DEB-models}},
\code{\link{GUTS-RED-models}},
\code{\link{Lemna-models}},
\code{\link{Macrophyte-models}},
\code{\link{Myriophyllum-models}},
\code{\link{Scenarios}}
}
\concept{scenarios}
