% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geNorm.R
\name{geNorm}
\alias{geNorm}
\title{Ranks genes}
\usage{
geNorm(expression, genes = data.frame(Genes = character(0), Avg.M =
  numeric(0)), ctVal = TRUE)
}
\arguments{
\item{expression}{a matrix of expression levels. Each row corresponds to a sample and each column to a gene.}

\item{genes}{a data frame to output the result of the function}

\item{ctVal}{a logical value indicating data type. If ct-values are input, ctVal=TRUE, otherwise, ctVal=FALSE.}
}
\value{
A sorted dataframe with two columns, 'Genes' and 'Avg.M'. The last two genes are the two most stable control genes.

Avg.M is average expression stability values (M) of remaining control genes during stepwise exclusion of the least stable control gene.
}
\description{
Uses the geNorm algorithm to determine the most stably expressed genes.
}
\examples{
FIB
geNorm(FIB,ctVal=FALSE)
FIBct
geNorm(FIBct)
}
\references{
Vandesompele J, De Preter K, Pattyn F, Poppe B, Van Roy N, De Paepe A, Speleman F (2002) <doi: 10.1186/gb-2002-3-7-research0034>.
}
