% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_publications.R
\name{extract_publications}
\alias{extract_publications}
\title{Takes a data frame of the type provided by
\code{clinicaltrials_gov_download()} and returns a new data frame
containing one row per publication of the publication type
specified indexed on ClinicalTrials.gov for every version of the
clinical trial record provided.}
\usage{
extract_publications(df, types = c("RESULT", "BACKGROUND", "DERIVED"))
}
\arguments{
\item{df}{A data frame containing at least the following columns:
\code{nctid}, \code{version_number}, \code{total_versions}, \code{version_date},
and \code{references}. The \code{references} column should contain a
nested JSON-encoded table with three columns: \code{pmid}, \code{type}
and \code{citation}. This data frame can be generated by the use of
\code{clinicaltrials_gov_download}.}

\item{types}{A list of types to be returned or a character string
if only one type specified, e.g. "RESULT" or c("RESULT",
"BACKGROUND"). Allowed types: "RESULT", "BACKGROUND",
"DERIVED".}
}
\value{
A data frame with all the original columns, as well as an
additional three columns: \code{pmid}, \code{type} and \code{citation}. The
new data frame will have one row per publication.
}
\description{
This function does not connect to ClinicalTrials.gov, and only
interprets data that has already been downloaded by expanding the
nested JSON-encoded data in the \code{references} column provided by
\code{clinicaltrial_gov_version}.
}
\examples{

\donttest{
hv <- clinicaltrials_gov_download("NCT00942747", latest=TRUE)
extract_publications(hv)
}
}
