% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-variables.R
\name{makeCaseVariable}
\alias{makeCaseVariable}
\title{Make a case variable}
\usage{
makeCaseVariable(..., cases, data = NULL, name)
}
\arguments{
\item{...}{a sequence of named expressions to use as cases as well as other
properties to pass about the case variable (i.e. alias, description)}

\item{cases}{a list of lists with each case condition to use each must
include at least a \code{name} and an \code{expression} element. Cases may also include
\code{missing} (logical) and \code{numeric_value} (numeric).}

\item{data}{(optional) a crunch dataset to use. Specifying this means you
don't have to put \code{dataset$} in front of each variable name.}

\item{name}{a character to use as the name of the case variable to create}
}
\value{
A \code{\link{VariableDefinition}} that will create the new
case variable when assigned into the Dataset.
}
\description{
The \code{makeCaseVariable} function derives a variable using values from other
variables. These are evaluated in the order they are supplied in the list
as the \code{cases} argument (they proceed in an IF, ELSE IF, ELSE IF, ..., ELSE
fashion); the first one that matches selects the corresponding value from
the case list.
}
\details{
There are two ways to specify cases, but you must pick only one (note these
two will produce the same case variable):
\enumerate{
\item When you just want to specify conditions, you can use named conditions:
\code{makeCaseVariable(case1=ds$v1 == 1, case2=ds$v2 == 2, name="new case")}
\item You can also use the \code{cases} argument, which is useful when you want to
provide category ids, numeric values, or missingness:
\code{makeCaseVariable(cases=list(list(expression=ds$v1 == 1, name="case1"), list(expression=ds$v2 == 2, name="case2")), name="new case")}
}

Rows in the dataset that do not match any of the provided "cases" will
be assigned to an "else" category. By default, Crunch will use the system
missing "No Data" category. Alternatively, you can provide an else
case definition for these rows by including as the last "case" you provide
one with its \code{expression} set to the string "else". See the examples for
details.
}
\examples{
\dontrun{
makeCaseVariable(case1=ds$v1 == 1, case2=ds$v2 == 2, name="new case")
makeCaseVariable(cases=list(list(expression=ds$v1 == 1, name="case1"),
                            list(expression=ds$v2 == 2, name="case2")),
                 name="new case")

# different ways to specify else cases
makeCaseVariable(cases=list(list(expression=ds$v1 == 1, name="case1"),
                            list(expression=ds$v2 == 2, name="case2"),
                            list(expression="else", name="other")),
                 name="new case")
makeCaseVariable(case1=ds$v1 == 1, case2=ds$v2 == 2, other="else", name="new case")

# the dataset can be specified with data=
makeCaseVariable(case1=v1 == 1, case2=v2 == 2, data=ds, name="new case")
}
}
