% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-catalog.R, R/dataset.R
\docType{methods}
\name{is.archived,DatasetCatalog-method}
\alias{is.archived,DatasetCatalog-method}
\alias{is.draft,DatasetCatalog-method}
\alias{is.published,DatasetCatalog-method}
\alias{is.archived<-,DatasetCatalog,logical-method}
\alias{is.draft<-,DatasetCatalog,logical-method}
\alias{is.published<-,DatasetCatalog,logical-method}
\alias{archive-and-publish}
\alias{archive}
\alias{is.archived}
\alias{is.draft}
\alias{is.published}
\alias{is.archived<-}
\alias{is.draft<-}
\alias{is.published<-}
\alias{publish}
\alias{is.archived,CrunchDataset-method}
\alias{is.draft,CrunchDataset-method}
\alias{is.published,CrunchDataset-method}
\alias{is.archived<-,CrunchDataset,logical-method}
\alias{archive}
\alias{is.draft<-,CrunchDataset,logical-method}
\alias{is.published<-,CrunchDataset,logical-method}
\alias{publish}
\title{Get and set "archived" and "published" status of a dataset}
\usage{
\S4method{is.archived}{DatasetCatalog}(x)

\S4method{is.draft}{DatasetCatalog}(x)

\S4method{is.published}{DatasetCatalog}(x)

\S4method{is.archived}{DatasetCatalog,logical}(x) <- value

\S4method{is.draft}{DatasetCatalog,logical}(x) <- value

\S4method{is.published}{DatasetCatalog,logical}(x) <- value

\S4method{is.archived}{CrunchDataset}(x)

\S4method{is.draft}{CrunchDataset}(x)

\S4method{is.published}{CrunchDataset}(x)

\S4method{is.archived}{CrunchDataset,logical}(x) <- value

archive(x)

\S4method{is.draft}{CrunchDataset,logical}(x) <- value

\S4method{is.published}{CrunchDataset,logical}(x) <- value

publish(x)
}
\arguments{
\item{x}{CrunchDataset}

\item{value}{logical}
}
\value{
For the getters, the logical value of whether the dataset is
archived, in draft mode, or published, where draft and published are
inverses. The setters return the dataset.
}
\description{
"Archived" datasets are excluded from some views. "Draft" datasets are
visible only to editors. "Published" is the inverse of "Draft", i.e.
\code{is.draft(x)} entails \code{!is.published(x)}. These properties are
accessed and set with the "is" methods. The verb functions \code{archive}
and \code{publish} are alternate versions of the setters (at least in the
\code{TRUE} direction).
}
