% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm_html.R
\name{crm_html}
\alias{crm_html}
\title{Get full plain text}
\usage{
crm_html(url, overwrite_unspecified = FALSE, ...)
}
\arguments{
\item{url}{A URL (character) or an object of class \code{tdmurl} from a call
to \code{\link[=crm_links]{crm_links()}}. If you'll be getting text from the publishers are use
Crossref TDM (which requires authentication), we strongly recommend
using \code{\link[=crm_links]{crm_links()}} first and passing output of that here, as \code{\link[=crm_links]{crm_links()}}
grabs the publisher Crossref member ID, which we use to do authentication
and other publisher specific fixes to URLs}

\item{overwrite_unspecified}{(logical) Sometimes the crossref API returns
mime type 'unspecified' for the full text links (for some Wiley dois
for example). This parameter overrides the mime type to be \code{type}.}

\item{...}{Named curl parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}, see
\code{\link[curl:curl_options]{curl::curl_options()}} for available curl options}
}
\description{
Get full plain text
}
\details{
Note that this function is not vectorized. To do many requests
use a for/while loop or lapply family calls, or similar.

Note that some links returned will not in fact lead you to full text
content as you would understandbly think and expect. That is, if you
use the \code{filter} parameter with e.g., \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}}
and filter to only full text content, some links may actually give back
only metadata for an article. Elsevier is perhaps the worst offender,
for one because they have a lot of entries in Crossref TDM, but most
of the links that are apparently full text are not in facct full text,
but only metadata.

Check out \link{auth} for details on authentication.
}
\examples{
\dontrun{
link <- crm_links("10.7717/peerj.1545", "html")
crm_html(link)

link <- crm_links("10.7717/peerj.1545")
crm_html(link)

crm_html("https://peerj.com/articles/1545.html")
}
}
