% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingTargetProb-class}
\alias{StoppingTargetProb-class}
\alias{.StoppingTargetProb}
\alias{StoppingTargetProb}
\alias{.DefaultStoppingTargetProb}
\title{\code{StoppingTargetProb}}
\usage{
StoppingTargetProb(
  target = c(0.2, 0.35),
  prob = 0.4,
  report_label = NA_character_
)

.DefaultStoppingTargetProb()
}
\arguments{
\item{target}{(\code{number})\cr see slot definition.}

\item{prob}{(\code{proportion})\cr see slot definition.}

\item{report_label}{(\code{string} or \code{NA})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{StoppingTargetProb}} is the class for stopping based on the probability of
the DLT rate being in the target toxicity interval.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{number})\cr the target toxicity interval, e.g. \code{c(0.2, 0.35)}.}

\item{\code{prob}}{(\code{proportion})\cr required target toxicity probability (except 0 or 1)
for reaching sufficient precision.}
}}

\note{
Typically, end users will not use the \code{.DefaultStoppingTargetProb()} function.
}
\examples{
# As example, here is the rule for stopping the study if the posterior
# probability that [0.2 =< Prob(DLT | dose) <= 0.35] for the next best dose
# is above 0.5.
my_stopping <- StoppingTargetProb(target = c(0.2, 0.35), prob = 0.5)
}
