% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelParams-class.R
\docType{class}
\name{ModelParamsNormal-class}
\alias{ModelParamsNormal-class}
\alias{.ModelParamsNormal}
\alias{ModelParamsNormal}
\alias{.DefaultModelParamsNormal}
\title{\code{ModelParamsNormal}}
\usage{
ModelParamsNormal(mean, cov)

.DefaultModelParamsNormal()
}
\arguments{
\item{mean}{(\code{numeric})\cr the prior mean vector.}

\item{cov}{(\code{matrix})\cr the prior covariance matrix. The precision matrix
\code{prec} is internally calculated as an inverse of \code{cov}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{ModelParamsNormal}} is the class for a bivariate normal model parameters,
i.e. the mean vector, covariance matrix and precision matrix.
The precision matrix is an inverse of the covariance matrix in the
\code{JAGS} and it is computed internally by the object constructor function.
}
\section{Slots}{

\describe{
\item{\code{mean}}{(\code{numeric})\cr the mean vector.}

\item{\code{cov}}{(\code{matrix})\cr the covariance matrix.}

\item{\code{prec}}{(\code{matrix})\cr the precision matrix, which is an inverse matrix of the \code{cov}.}
}}

\note{
Typically, end users will not use the \code{.ModelPAramsNormal()} function.
}
\examples{
ModelParamsNormal(mean = c(1, 6), cov = diag(2))
}
\seealso{
\code{\link{ModelLogNormal}}, \code{\link{LogisticNormalMixture}}.
}
