% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetDistribTaxa.R
\name{getDistribTaxa}
\alias{getDistribTaxa}
\title{Extract taxonID(s) corresponding to the taxonomic description}
\usage{
getDistribTaxa(
  taxIDs,
  climate = NA,
  xmn = NA,
  xmx = NA,
  ymn = NA,
  ymx = NA,
  continents = NA,
  countries = NA,
  basins = NA,
  sectors = NA,
  realms = NA,
  biomes = NA,
  ecoregions = NA,
  elev_min = NA,
  elev_max = NA,
  elev_range = NA,
  year_min = 1900,
  year_max = 2021,
  nodate = TRUE,
  type_of_obs = c(1, 2, 3, 8, 9),
  dbname = "gbif4crest_02"
)
}
\arguments{
\item{taxIDs}{A vector of accepted Taxa IDs (as returned by \code{\link{getTaxonID}}).}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{xmn, xmx, ymn, ymx}{The coordinates defining the study area.}

\item{continents}{A vector of the continent names defining the study area.}

\item{countries}{A vector of the country names defining the study area.}

\item{basins}{A vector of the ocean names defining the study area.}

\item{sectors}{A vector of the marine sector names defining the study area.}

\item{realms}{A vector of the studied botanical realms defining the study area.}

\item{biomes}{A vector of the studied botanical biomes defining the study area.}

\item{ecoregions}{A vector of the studied botanical ecoregions defining the
study area.}

\item{elev_min, elev_max}{Parameters to only selected grid cells with an
elevation higher than elev_min or lower than elev_max (default is
'\code{NA} ).}

\item{elev_range}{Parameters discard the grid cell with a high elevation
range (default is \code{NA}).}

\item{year_min, year_max}{The oldest and youngest occurrences accepted
(default is 1900-2021).}

\item{nodate}{A boolean to accept occurrences without a date (can overlap
with occurrences with a date; default \code{TRUE}).}

\item{type_of_obs}{The type of observation to use in the study. 1: human
observation, 2: observation, 3: preserved specimen, 4: living specimen,
5: fossil specimen, 6: material sample, 7: machine observation, 8:
literature, 9: unknown (Default \code{c(1, 2, 3, 8, 9)})}

\item{dbname}{The name of the data source database.}
}
\value{
A matrix of occurrence records with the associated climate.
}
\description{
Extract all possible TaxonIDs corresponding to the provided taxonomical
description, which can be at the family, the genus or the species levels.
}
\examples{
\dontrun{
  taxIDs <- getTaxonID("Zamiaceae", "Ceratozamia")
  distrib <- getDistribTaxa(taxIDs, "bio1", -90, 90, -90, 90,
    continents = "Europe",
    countries = c("Germany", "Netherlands", "Sweden"),
    realms = "Palaearctic"
  )
  distrib
}

}
\seealso{
\code{\link{getTaxonID}} for taxIDs, \code{\link{accClimateVariables}}
for a list of accepted climate variable names, \code{\link{accCountryNames}}
for a list of accepted continent and country names, \code{\link{accRealmNames}}
for a list of accepted realm, biome and ecoregion names.
}
