% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/string_operations.r
\name{col_nchar}
\alias{col_nchar}
\title{Count number of characters in an ANSI colored string}
\usage{
col_nchar(x, ...)
}
\arguments{
\item{x}{Character vector, potentially ANSO styled, or a vector to be
coarced to character.}

\item{...}{Additional arguments, passed on to \code{base::nchar}
after removing ANSI escape sequences.}
}
\value{
Numeric vector, the length of the strings in the character
  vector.
}
\description{
This is a color-aware counterpart of \code{base::nchar},
which does not do well, since it also counts the ANSI control
characters.
}
\examples{
str <- paste(
  red("red"),
  "default",
  green("green")
)

cat(str, "\\n")
nchar(str)
col_nchar(str)
nchar(strip_style(str))
}
\seealso{
Other ANSI string operations: \code{\link{col_strsplit}};
  \code{\link{col_substring}}; \code{\link{col_substr}}
}

