% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{mcmc_mix3_wrapper}
\alias{mcmc_mix3_wrapper}
\title{Wrapper of mcmc_mix3}
\usage{
mcmc_mix3_wrapper(
  df,
  seed,
  a_psi1 = 1,
  a_psi2 = 1,
  a_psiu = 0.001,
  b_psiu = 0.9,
  m_alpha = 0,
  s_alpha = 10,
  a_theta = 1,
  b_theta = 1,
  m_shape = 0,
  s_shape = 10,
  a_sigma = 1,
  b_sigma = 0.01,
  a_pseudo = 10,
  b_pseudo = 1,
  pr_power2 = 0.5,
  powerlaw1 = FALSE,
  positive1 = FALSE,
  positive2 = TRUE,
  iter = 20000L,
  thin = 20L,
  burn = 100000L,
  freq = 1000L,
  mc3 = FALSE,
  invts = 0.001^((0:8)/8),
  name = TRUE
)
}
\arguments{
\item{df}{A data frame with at least two columns, x & count}

\item{seed}{Integer for \code{set.seed}}

\item{a_psi1, a_psi2, a_psiu, b_psiu, m_alpha, s_alpha, a_theta, b_theta, m_shape, s_shape, a_sigma, b_sigma}{Scalars, real numbers representing the hyperparameters of the prior distributions for the respective parameters. See details for the specification of the priors.}

\item{a_pseudo}{Positive real number, first parameter of the pseudoprior beta distribution for theta2 in model selection; ignored if pr_power2 = 1.0}

\item{b_pseudo}{Positive real number, second parameter of the pseudoprior beta distribution for theta2 in model selection; ignored if pr_power2 = 1.0}

\item{pr_power2}{Real number in [0, 1], prior probability of the discrete power law (between v and u)}

\item{powerlaw1}{Boolean, is the discrete power law assumed for below v?}

\item{positive1}{Boolean, is alpha1 positive (TRUE) or unbounded (FALSE)?}

\item{positive2}{Boolean, is alpha2 positive (TRUE) or unbounded (FALSE)?}

\item{iter}{Positive integer representing the length of the MCMC output}

\item{thin}{Positive integer representing the thinning in the MCMC}

\item{burn}{Non-negative integer representing the burn-in of the MCMC}

\item{freq}{Positive integer representing the frequency of the sampled values being printed}

\item{mc3}{Boolean, is Metropolis-coupled MCMC to be used?}

\item{invts}{Vector of the inverse temperatures for Metropolis-coupled MCMC; ignored if mc3 = FALSE}

\item{name}{Boolean; if the column \code{name} exists, are its unique values printed?}
}
\value{
A list returned by \code{mcmc_mix3}
}
\description{
Wrapper of mcmc_mix3
}
