% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cram_learning.R
\name{cram_learning}
\alias{cram_learning}
\title{Cram Policy Learning}
\usage{
cram_learning(
  X,
  D,
  Y,
  batch,
  model_type = "causal_forest",
  learner_type = "ridge",
  baseline_policy = NULL,
  parallelize_batch = FALSE,
  model_params = NULL,
  custom_fit = NULL,
  custom_predict = NULL,
  n_cores = detectCores() - 1,
  propensity = NULL
)
}
\arguments{
\item{X}{A matrix or data frame of covariates for each sample.}

\item{D}{A vector of binary treatment indicators (1 for treated, 0 for untreated).}

\item{Y}{A vector of outcome values for each sample.}

\item{batch}{Either an integer specifying the number of batches (which will be created by random sampling) or a vector of length equal to the sample size providing the batch assignment (index) for each individual in the sample.}

\item{model_type}{The model type for policy learning. Options include \code{"causal_forest"}, \code{"s_learner"}, and \code{"m_learner"}. Default is \code{"causal_forest"}. Note: you can also set model_type to NULL and specify custom_fit and custom_predict to use your custom model.}

\item{learner_type}{The learner type for the chosen model. Options include \code{"ridge"} for Ridge Regression, \code{"fnn"} for Feedforward Neural Network and \code{"caret"} for Caret. Default is \code{"ridge"}. if model_type is 'causal_forest', choose NULL, if model_type is 's_learner' or 'm_learner', choose between 'ridge', 'fnn' and 'caret'.}

\item{baseline_policy}{A list providing the baseline policy (binary 0 or 1) for each sample. If \code{NULL}, the baseline policy defaults to a list of zeros with the same length as the number of rows in \code{X}.}

\item{parallelize_batch}{Logical. Whether to parallelize batch processing (i.e. the cram method learns T policies, with T the number of batches. They are learned in parallel when parallelize_batch is TRUE vs. learned sequentially using the efficient data.table structure when parallelize_batch is FALSE, recommended for light weight training). Defaults to \code{FALSE}.}

\item{model_params}{A list of additional parameters to pass to the model, which can be any parameter defined in the model reference package. Defaults to \code{NULL}.}

\item{custom_fit}{A custom, user-defined, function that outputs a fitted model given training data (allows flexibility). Defaults to \code{NULL}.}

\item{custom_predict}{A custom, user-defined, function for making predictions given a fitted model and test data (allow flexibility). Defaults to \code{NULL}.}

\item{n_cores}{Number of cores to use for parallelization when parallelize_batch is set to TRUE. Defaults to detectCores() - 1.}

\item{propensity}{The propensity score}
}
\value{
A list containing:
  \item{final_policy_model}{The final fitted policy model, depending on \code{model_type} and \code{learner_type}.}
  \item{policies}{A matrix of learned policies, where each column represents a batch's learned policy and the first column is the baseline policy.}
  \item{batch_indices}{The indices for each batch, either as generated (if \code{batch} is an integer) or as provided by the user.}
}
\description{
This function performs the learning part of the Cram Policy method.
}
\seealso{
\code{\link[grf]{causal_forest}}, \code{\link[glmnet]{cv.glmnet}}, \code{\link[keras]{keras_model_sequential}}
}
