% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aut1(mrc).R
\name{mrc.mean1}
\alias{mrc.mean1}
\title{Segmenting data using PELT funtion.}
\usage{
mrc.mean1(data, beta = 1.5 * log(n))
}
\arguments{
\item{data}{a censored data matrix.}

\item{beta}{default 1.5*log(n).}
}
\value{
data
}
\description{
To find changepoints using mrc method consisting
of many related univariate timeseries, segmenting
the data using PELT function (Killick, Fearnhead,
and Eckley 2012) in such a way that cost is minimum.
}
\examples{
#example(right censoring)
library(cpcens)
data("censoredex")
data=censoredex
n=144
mrc = mrc.mean1( data , beta = 1.5*log(n) )
mrc
}
