% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind(PELT).R
\name{ind}
\alias{ind}
\title{Most recent changepoint using ind method}
\usage{
ind(data, pen = 0)
}
\arguments{
\item{data}{a censored data matrix}

\item{pen}{(penalty term)  default 2*log(n). If pen is equal to zero, penalty term will be equal
to 2*log(n)}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Analyzing each series in the panel independently (IND)
method that is the simplest one to analyze all the series independently
in the panel data and in each given series estimate the most recent
changepoint. We use PELT for segmenting a time series into changing
means, assumes normally distributed observations
with changing mean but constant variance
}
\examples{
#Default example
library(cpcens)
data("censoredex")
data=censoredex
n=144
N=100
out=ind(data, pen=0)
}
