% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bubble.R
\name{bubble_tail}
\alias{bubble_tail}
\alias{bubble_tail2}
\title{Make the tail part of a thought bubble}
\usage{
bubble_tail(animal, thought_sym = "o")

bubble_tail2(max_char_length, thought_sym = "o")
}
\arguments{
\item{animal}{(character) a string}

\item{thought_sym}{(character) scalar character to use for the
speech bubble tail (see \url{https://en.wikipedia.org/wiki/Speech_balloon}).
default: "o"}

\item{max_char_length}{(numeric) length of the maximum line. this is used
to determine how much whitespace padding to add to the left of
\code{thought_sym}}
}
\description{
Make the tail part of a thought bubble
}
\details{
\code{bubble_tail} uses the animal as input so that the tail is put
close to the top of the animal, whereas \code{bubble_tail2} just puts the tail
about a 1/3 of the way from the left most character given the max
character length
}
\examples{
bubble_tail(animals[["chicken"]])
cat(bubble_tail(animals[["chicken"]]), sep = "\n")
cat(bubble_tail(animals[["chicken"]]), sep = "\n")
cat(bubble_tail(animals[["chicken"]], "\%"), sep = "\n")

bubble_tail2(59)
cat(bubble_tail2(59), sep = "\n")
cat(bubble_tail2(11), sep = "\n")
cat(bubble_tail2(11, "\%"), sep = "\n")
}
\seealso{
Other bubble: 
\code{\link{bubble_say}()}
}
\concept{bubble}
