% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_available_datasets.R
\name{get_available_datasets}
\alias{get_available_datasets}
\title{Get supported data sets}
\usage{
get_available_datasets(type, render = FALSE, namespace = "covidregionaldata")
}
\arguments{
\item{type}{A character vector indicating the types of data to
return. Current options include "national" (which are datasets at the
national level which inherit from \code{CountryDataClass}) and
"regional" (which are datasets at the regional level which inherit
directly from \code{DataClass()}).}

\item{render}{Logical If TRUE the supported data set table is built from the
available classes using \code{summary} methods. If FALSE the supported
data set table is taken from package data. Defaults to FALSE.}

\item{namespace}{Character string The name of the namespace to search for
class objects. Defaults to "covidregionaldata" as the package.}
}
\value{
A list of available data sets and the spatial aggregation data is
available for.
}
\description{
Returns data on what countries are available from
the data provided with this package either using a cached dataset or built
by searching the target namespace.
}
\examples{
# see all available datasets
get_available_datasets()

# see only national level datasets
get_available_datasets("national")

# see only regional level datasets
get_available_datasets("regional")

# render the data
get_available_datasets(render = TRUE)
}
\seealso{
Data interface functions
\code{\link{CountryDataClass}},
\code{\link{DataClass}},
\code{\link{get_national_data}()},
\code{\link{get_regional_data}()},
\code{\link{initialise_dataclass}()}
}
\concept{interface}
