% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Salts_Drug}
\alias{Salts_Drug}
\title{Drug Salts}
\format{
a tibble with 8 variables:
\describe{
  \item{drugbank-id}{DrugBank identifiers of the available salt form(s)}
  \item{name}{Name of the available salt form(s)}
  \item{unii}{Unique Ingredient Identifier (UNII) of the available 
  salt form(s).}
  \item{cas-number}{Chemical Abstracts Service (CAS) registry number assigned
   to the salt form(s) of the drug.}
  \item{inchikey}{\href{http://www.inchi-trust.org/}{IUPAC International 
  Chemical Identifier (InChi)} key identifier for the available salt form(s)}
  \item{average-mass}{Average molecular mass: the weighted average of the
   isotopic masses of the salt.}
  \item{monoisotopic-mass}{The mass of the most abundant isotope of the salt}
  \item{parent_key}{drugbank id}
}
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Salts_Drug
}
\description{
Available salt forms of the drug. Ions such as hydrochloride, sodium, and 
sulfate are often added to the drug molecule to increase solubility, 
dissolution, or absorption.
}
\details{
Each drug may have one or more salt.
}
\keyword{datasets}
