% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ATC_Codes_Drug}
\alias{ATC_Codes_Drug}
\title{Drug related ATC Codes}
\format{
a tibble with 4 variables:
\describe{
  \item{atc_code}{drug related atc code}
  \item{level_n}{atc-code related level_n}
  \item{code_n}{atc-code and level_n related code_n}
  \item{drugbank-id}{drugbank id}
}
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
ATC_Codes_Drug
}
\description{
The Anatomical Therapeutic Classification (ATC) code for the drug assigned by
the \href{http://www.who.int/classifications/atcddd/en/}{World Health
Organization Anatomical Chemical Classification System}.
}
\details{
Each drug may have one or more atc-code.

Each atc-code has one or more level.

The atc-code and level elements each have a code which specifies the code
assigned by \href{http://www.who.int/classifications/atcddd/en/}{World Health
Organization Anatomical Chemical Classification System}.
}
\keyword{datasets}
