% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadData.R
\name{downloadCovid19}
\alias{downloadCovid19}
\alias{downloadCovid}
\title{Function to download COVID-19 data from web repositories}
\usage{
downloadCovid19(level = c("brazil", "regions", "states", "cities", "world"))
}
\arguments{
\item{level}{the desired level of data aggregation:  "brazil" (default), "regions", "states", "cities", and "world".}
}
\value{
a tibble containing the downloaded data at the specified level.
}
\description{
This function downloads the pandemic COVID-19 data at Brazil and World basis. Brazilan data is available at national, region, state, and city levels, whereas the world data are available at the country level.
}
\details{
The Brazilian data provided by the Brazilian government at its official repository (https://covid.saude.gov.br/) is available in a single xlsx file. That file contains data aggregated at national, state, and city geographic levels.  Because importing such data file into R requires a considerable amount of RAM (over 4G), the data is daily downloaded with the internal function  \code{downloadMS}, and then made available in smaller/lighter binary files at a GitHub repository (https://github.com/dest-ufmg/covid19repo) maintained by the authors' package.
}
\examples{
\donttest{
library(covid19br)

# Downloading Brazilian COVID-19 data:
brazil <- downloadCovid19(level = "brazil")
regions <- downloadCovid19(level = "regions")
states <- downloadCovid19(level = "states")
cities <- downloadCovid19(level = "cities")

# Downloading world COVID-19 data:
world <- downloadCovid19(level = "world")
}

}
