% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid19_models.R
\name{sweep.SIR.models}
\alias{sweep.SIR.models}
\title{function to perform a sweep of models and generate values of R0}
\usage{
sweep.SIR.models(
  data = NULL,
  geo.loc = "Hubei",
  t0_range = 15:20,
  t1 = NULL,
  deltaT = NULL,
  tfinal = 90,
  fatality.rate = 0.02,
  tot.population = 1.4e+09
)
}
\arguments{
\item{data}{time series dataset to consider}

\item{geo.loc}{country/region to analyze}

\item{t0_range}{range of initial date for data consideration}

\item{t1}{final period of time for data consideration}

\item{deltaT}{interval period of time from t0, ie. number of days to consider since t0}

\item{tfinal}{total number of days}

\item{fatality.rate}{rate of causality, deafault value of 2 percent}

\item{tot.population}{total population of the country/region}
}
\description{
function to perform a sweep of models and generate values of R0
}
\examples{
# read TimeSeries data
TS.data <- covid19.data("TS-confirmed")
# select a location of interest, eg. France
# France has many entries, just pick "la France"
France.data <- TS.data[ (TS.data$Country.Region == "France") & (TS.data$Province.State == ""),]
# sweep values of R0 based on range of dates to consider for the model
ranges <- 15:20
deltaT <- 20
params_sweep <- sweep.SIR.models(data=France.data,geo.loc="France", t0_range=ranges, deltaT=deltaT)
# obtain the R0 values from the parameters
R0s <- unlist(params_sweep["R0",])
# nbr of infected cases
FR.infs<- preProcessingData(France.data,"France")
# average per range
# define ranges
lst.ranges <- lapply(ranges, function(x) x:(x+deltaT))
# compute averages
avg.FR.infs <- lapply(lst.ranges, function(x) mean(FR.infs[x]))
# plots
plot(R0s, type='b')
# plot vs average number of infected cases
plot(avg.FR.infs, R0s, type='b')

}
