% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_wide_format.R
\name{check_wide_format}
\alias{check_wide_format}
\title{Check for wide country data formats}
\usage{
check_wide_format(x, adjacency = TRUE)
}
\arguments{
\item{x}{A dataframe}

\item{adjacency}{Logical value indicating whether column names containing country or year information need to be adjacent to each other. Default is \code{TRUE}}
}
\value{
Returns a data.frame identifying the columns names that contain country or year information.
}
\description{
The function looks for country names or year information in the column names. This function is designed for simple panel country data, in which countries' time series are arranged side by side on columns or stacked on rows.
The function will only return year/country column names if at least 3 country/year column names are detected.
}
\examples{
example <- data.frame(Year=2000:2010, China=0:10, US=10:20, Vietnam=30:40)
check_wide_format(x=example)
}
\seealso{
\link[countries]{find_keycol}, \link[countries]{find_countrycol}, \link[countries]{find_timecol}
}
