% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cops.R
\name{copstressMin}
\alias{copstressMin}
\title{Fitting a COPS-C Model (COPS Variant 1).}
\usage{
copstressMin(delta, kappa = 1, lambda = 1, nu = 1, theta = c(kappa,
  lambda, nu), type = c("ratio", "interval", "ordinal"),
  ties = "primary", weightmat = 1 - diag(nrow(delta)), ndim = 2,
  init = NULL, stressweight = 0.975, cordweight = 0.025, q = 1,
  minpts = ndim + 1, epsilon = 10, dmax = NULL, rang,
  optimmethod = c("NelderMead", "Newuoa", "BFGS", "SANN", "hjk", "solnl",
  "solnp", "subplex", "snomadr", "hjk-Newuoa", "hjk-BFGS", "BFGS-hjk",
  "Newuoa-hjk", "cmaes", "direct", "direct-Newuoa", "direct-BFGS",
  "genoud", "gensa"), verbose = 0, scale = c("sd", "rmsq", "std",
  "proc", "none"), normed = TRUE, accuracy = 1e-07, itmax = 5000,
  stresstype = c("stress-1", "stress"), ...)
}
\arguments{
\item{delta}{numeric matrix or dist object of a matrix of proximities}

\item{kappa}{power transformation for fitted distances}

\item{lambda}{power transformation for proximities}

\item{nu}{power transformation for weights}

\item{theta}{the theta vector of powers; the first is kappa (for the fitted distances if it exists), the second lambda (for the observed proximities if it exist), the third is nu (for the weights if it exists) . If less than three elements are is given as argument, it will be recycled. Defaults to 1 1 1. Will override any kappa, lmabda, nu parameters if they are given and do not match}

\item{type}{what type of MDS to fit. Currently one of "ratio", "interval" or "ordinal". Default is "ratio".}

\item{ties}{the handling of ties for ordinal (nonmetric) MDS. Possible are "primary" (default), "secondary" or "tertiary".}

\item{weightmat}{(optional) a matrix of nonnegative weights; defaults to 1 for all off diagonals}

\item{ndim}{number of dimensions of the target space}

\item{init}{(optional) initial configuration}

\item{stressweight}{weight to be used for the fit measure; defaults to 0.975}

\item{cordweight}{weight to be used for the cordillera; defaults to 0.025}

\item{q}{the norm of the cordillera; defaults to 1}

\item{minpts}{the minimum points to make up a cluster in OPTICS; defaults to ndim+1}

\item{epsilon}{the epsilon parameter of OPTICS, the neighbourhood that is checked; defaults to 10}

\item{dmax}{The winsorization limit of reachability distances in the OPTICS Cordillera. If supplied, it should be either a numeric value that matches max(rang) or NULL; if NULL it is found as 1.5 times (for kappa >1) or 1 times (for kappa <=1) the maximum reachbility value of the power torgerson model with the same lambda. If dmax and rang are supplied and dmax is not max(rang), a warning is given and rang takes precedence.}

\item{rang}{range of the reachabilities to be considered. If missing it is found from the initial configuration by taking 0 as the lower boundary and dmax (see above) as upper boundary. See also \code{\link{cordillera}}}

\item{optimmethod}{What optimizer to use? Choose one string of 'Newuoa' (from package minqa), 'NelderMead', 'hjk' (Hooke-Jeeves algorithm from dfoptim), 'solnl' (from nlcOptim), 'solnp' (from Rsolnp), 'subplex' (from subplex), 'SANN' (simulated annealing), 'BFGS', 'snomadr' (from crs), 'genoud' (from rgenoud), 'gensa' (from GenSA), 'cmaes' (from cmaes) and 'direct' (from nloptr). See the according R packages for details on these solvers. There are also combinations that proved to work well good, like 'hjk-Newuoa', 'hjk-BFGS', 'BFGS-hjk', 'Newuoa-hjk', 'direct-Newuoa' and 'direct-BFGS' . Usually hjk, BFGS, newuoa, subplex and solnl work rather well in an acceptable time frame (depending on the smoothness of copstress). Default is 'hjk-Newuoa'.}

\item{verbose}{numeric value hat prints information on the fitting process; >2 is very verbose}

\item{scale}{Allows to scale the configuration for the OC (the scaled configuration is also returned as $conf). One of none (so no scaling), sd (configuration divided by the maximum standard deviation of the columns), std (standardize all columns !NOTE: This does not preserve the relative distances of the optimal config), proc (procrustes adjustment to the initial fit) and rmsq (configuration divided by the maximum root mean square of the columns). Default is sd.}

\item{normed}{should the cordillera be normed; defaults to TRUE}

\item{accuracy}{numerical accuracy, defaults to 1e-7}

\item{itmax}{maximum number of iterations. Defaults to 5000.}

\item{stresstype}{which stress to use in the copstress. Defaults to stress-1. If anything else is set, explicitly normed stress which is (stress-1)^2. Using stress-1 puts more weight on MDS fit.}

\item{...}{additional arguments to be passed to the optimization procedure}
}
\value{
A list with the components
        \itemize{
        \item delta: the original transformed dissimilarities
        \item obsdiss: the explicitly normed transformed dissimilarities (which are approximated by the fit)
        \item confdist: the fitted distances
        \item conf: the configuration to which the scaling of argument scale was applied
        \item confo: the unscaled but explicitly normed configuration returned from the fitting procedure. Scaling applied to confo gives conf.
        \item par, pars : the theta vector of powers tranformations (kappa,lambda,nu)
        \item niter: number of iterations of the optimizer. 
        \item stress: the square root of explicitly normalized stress (calculated for confo).
        \item spp: stress per point
        \item ndim: number of dimensions
        \item model: Fitted model name with optimizer
        \item call: the call
        \item nobj: the number of objects
        \item type, loss, losstype: stresstype
        \item stress.m: The stress used for copstress. If stresstype="stress-1" this is like $stress else it is stress^2
        \item stress.en: another ways to calculate the stress
        \item deltaorig: the original untransformed dissimilarities  
        \item copstress: the copstress loss value
        \item resmat: the matrix of residuals
        \item weightmat: the matrix of untransformed weights 
        \item OC: the (normed) OPTICS Cordillera object (calculated for scaled conf)
        \item OCv: the (normed) OPTICS Cordillera value alone (calculated for scaled conf)
        \item optim: the object returned from the optimization procedure
        \item stressweight, cordweight: the weights of the stress and OC respectively (v_1 and v_2)
        \item optimmethod: The solver used 
        \item type: the type of MDS fitted
}
}
\description{
Minimizing Copstress to obtain a clustered MDS configuration with given hyperparameters theta.
}
\examples{
dis<-as.matrix(smacof::kinshipdelta)

#Copstress with equal weight to stress and cordillera 
res1<-copstressMin(dis,stressweight=0.5,cordweight=0.5,itmax=1000) #use higher itmax about 10000 
res1
summary(res1)
plot(res1)  #super clustered

}
\keyword{clustering}
\keyword{multivariate}
