% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multitrait.R
\name{cophe.multitrait}
\alias{cophe.multitrait}
\title{Run cophescan on multiple traits at once}
\usage{
cophe.multitrait(
  trait.dat,
  querysnpid,
  querytrait.names,
  LDmat = NULL,
  method = "single",
  simplify = FALSE,
  predict.hyp = TRUE,
  Hn.cutoff = 0.2,
  Hc.cutoff = 0.6,
  est.fdr.based.cutoff = FALSE,
  fdr = 0.05,
  ...
)
}
\arguments{
\item{trait.dat}{Named(traits) list of coloc structured data for k traits (Total number of traits)}

\item{querysnpid}{vector of query variant ids = length(trait.dat), if the same variant}

\item{querytrait.names}{vector of names for the query traits, if the names of
the multi.dat list contain the trait names please pass querytrait.names=names(multi.dat)}

\item{LDmat}{LD matrix}

\item{method}{either 'single' for \code{cophe.single} or 'susie' for \code{cophe.susie}}

\item{simplify}{if TRUE removes intermediate results from output using 'multitrait.simplify'}

\item{predict.hyp}{if TRUE predicts the hypothesis based on the provided thresholds for pp.Hc and pp.Hn (overrides simplify) using \code{cophe.hyp.predict}}

\item{Hn.cutoff}{threshold for PP.Hc above which the associations are called Hc}

\item{Hc.cutoff}{threshold for PP.Hc above which the associations are called Hn}

\item{est.fdr.based.cutoff}{if True calculates the Hc.cutoff using 1-mean(PP.Hc)|PP.Hc > cutoff}

\item{fdr}{fdr threshold to estimate Hc.cutoff}

\item{...}{additional arguments of priors for \code{cophe.susie} or \code{cophe.single}}
}
\value{
if simplify is False returns multi-trait list of lists, each with:
\itemize{
\item a summary data.frame of the cophescan results
\item priors used
\item querysnp
\item querytrait
}
if simplify is TRUE only returns dataframe with posterior probabilties of Hn, Hc and Ha with no intermediate results
if predict.hyp is TRUE returns a dataframe with output of simplify and the predicted hypotheses for all associations
}
\description{
Run cophescan on multiple traits at once
}
\author{
Ichcha Manipur
}
