% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntwrkEdges.R
\name{ntwrkEdges}
\alias{ntwrkEdges}
\title{Compile List of Network Edges from a Contact Table}
\usage{
ntwrkEdges(
  x,
  importBlocks = FALSE,
  removeDuplicates = TRUE,
  parallel = FALSE,
  nCores = (parallel::detectCores()/2)
)
}
\arguments{
\item{x}{Output from the contactDur.all or contactDur.area functions. Can be
either a data frame or list of data frames.}

\item{importBlocks}{Logical. If true blocks will be carried over from x 
input, allowing for time-ordered and time-aggregated network creation. 
Defaults to FALSE.}

\item{removeDuplicates}{Logical. If x is from contactDur.all, to-from node 
pairs in output will be reported twice (i.e., nodes will be listed as 
both a to- and a from-node). If removeDuplicates == true, duplicated 
edges are removed. Defaults to TRUE.}

\item{parallel}{Logical. If TRUE, sub-functions within the ntwrkEdges
wrapper will be parallelized. Note that the only sub-functions 
parallelized here are called ONLY when importBlocks == TRUE, or when x is
a list of data frames.}

\item{nCores}{Integer. Describes the number of cores to be dedicated to 
parallel processes. Defaults to half of the maximum number of cores 
available (i.e., (parallel::detectCores()/2)).}
}
\value{
Output is a data frame with the following columns, and can easily 
   be used as input for igraph functions. 

   \item{from}{The "from" nodes in a contact network. Can also be considered
   "tail" nodes.}
   \item{to}{The "to" nodes in a contact network. Can also be considered
   "head" nodes.}
   \item{durations}{The duration of each contact reported in \code{x}.}
   \item{block}{(if applicable) time block during which reported contacts 
   occurred.}
}
\description{
This function takes the output from contactDur.all or contactDur.area and 
   generates a data frame showing the list of edges in the contact network.
}
\examples{
data("calves")

calves.dateTime<-datetime.append(calves, date = calves$date,
   time = calves$time) #create a dataframe with dateTime identifiers for location fixes.

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag,
   dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x,
   point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE,
   extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE,
   na.rm = TRUE, smooth.type = 1) #smooth to 5-min fix intervals.

calves.dist<-dist2All_df(x = calves.agg, parallel = FALSE,
   dataType = "Point", lonlat = FALSE) #calculate inter-animal distances at each timepoint.

calves.contact.NOblock<-contactDur.all(x = calves.dist, dist.threshold=1,
   sec.threshold=10, blocking = FALSE, equidistant.time = FALSE,
   parallel = FALSE, reportParameters = TRUE) 

calves.edges<-ntwrkEdges(x =calves.contact.NOblock, importBlocks = FALSE,
   removeDuplicates = TRUE)  

calves.network1 <- igraph::graph_from_data_frame(d=calves.edges,
   directed=FALSE)

igraph::V(calves.network1)$color<- "orange1"
igraph::V(calves.network1)$size <-13
igraph::E(calves.network1)$width <- calves.edges$duration
igraph::E(calves.network1)$color <- "black"
igraph::plot.igraph(calves.network1, vertex.label.cex=0.4,
   layout = igraph::layout.circle, main = "Inter-Calf Contacts") #plot the network

}
\keyword{contact}
\keyword{data-processing}
