% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/socialEdges.R
\name{socialEdges}
\alias{socialEdges}
\title{Identify Edges in Social Networks}
\usage{
socialEdges(x, alpha = 0.05, weight = NULL, removeDuplicates = TRUE)
}
\arguments{
\item{x}{A data frame created by a contactCompare function (e.g., 
contactCompare_chisq).}

\item{alpha}{Numerical threshold for determining social significance given 
p-values reported in x. Observations in x with p.values >= alpha will be 
returned by this function.}

\item{weight}{Vector of length nrow(data.frame(x)) denoting what 
information should be carried over from x to the function output (e.g., 
number of observed contacts). If the weight is not specified, the 
"weight" in function output is presented as the proportion of total 
potential contact durations that nodes were observed in contact with one 
another (in each separate timeblock if applicable).}

\item{removeDuplicates}{Logical. If removeDuplicates == true, duplicated 
edges are removed are removed from the output. Defaults to TRUE.}
}
\value{
Returns a list with three objects
   
   \item{Greater}{Data frame of dyads with more contacts than would be 
      expected at random given the chosen alpha level.}
   \item{Fewer}{Data frame of dyads with fewer contacts than would be 
      expected at random given the chosen alpha level.}
   \item{p.val_threshold}{Reports the chosen alpha level.}
}
\description{
This function identifies edges in social networks representative of 
   instances where there are greater or fewer contacts than would
   be expected at random, given a pre-determined p-value threshold for 
   significance (i.e., alpha level).
}
\details{
This function will automatically import defined time blocks if applicable. 
   Furthermore, because this function is intended describe social 
   relationships between individuals, any "totalDegree" and 
   "totalContactDurations" metrics are not included in function output, 
   even if they are present in x.
}
\examples{
\donttest{
data(calves) #load data

calves.dateTime<-datetime.append(calves, date = calves$date,
                                 time = calves$time) #add dateTime column

calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag,
                       dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x,
                       point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE,
                       extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE,
                       na.rm = TRUE, smooth.type = 1) #aggregate to 5-min timepoints

calves.dist<-dist2All_df(x = calves.agg, parallel = FALSE,
                       dataType = "Point", lonlat = FALSE) #calculate  inter-calf distances

calves.contact.block<-contactDur.all(x = calves.dist, dist.threshold=1,
                       sec.threshold=10, blocking = TRUE, blockUnit = "hours", blockLength = 1,
                       equidistant.time = FALSE, parallel = FALSE, reportParameters = TRUE)

emp.summary <- summarizeContacts(calves.contact.block, 
                                 importBlocks = TRUE) #empirical contact summ.
emp.potential <- potentialDurations(calves.dist, blocking = TRUE, 
                                    blockUnit = "hours", blockLength = 1, 
                                    distFunction = "dist2All_df") 

calves.agg.rand<-randomizePaths(x = calves.agg, id = "id",
                       dateTime = "dateTime", point.x = "x", point.y = "y", poly.xy = NULL,
                       parallel = FALSE, dataType = "Point", numVertices = 1, blocking = TRUE,
                       blockUnit = "mins", blockLength = 20, shuffle.type = 0, shuffleUnit = NA,
                       indivPaths = TRUE, numRandomizations = 2) #randomize calves.agg

calves.dist.rand<-dist2All_df(x = calves.agg.rand, point.x = "x.rand",
                       point.y = "y.rand", parallel = FALSE, dataType = "Point", lonlat = FALSE)

calves.contact.rand<-contactDur.all(x = calves.dist.rand,
                       dist.threshold=1, sec.threshold=10, blocking = TRUE, blockUnit = "hours",
                       blockLength = 1, equidistant.time = FALSE, parallel = FALSE,
                       reportParameters = TRUE) #NULL model contacts (list of 2)

rand.summary <- summarizeContacts(calves.contact.rand, avg = TRUE,
                                  importBlocks = TRUE) #NULL contact summary
rand.potential <- potentialDurations(calves.dist.rand, blocking = TRUE, 
                                     blockUnit = "hours", blockLength = 1, 
                                     distFunction = "dist2All_df") 

CC1 <-contactCompare_chisq(x.summary = emp.summary, y.summary = rand.summary, 
                     x.potential = emp.potential, y.potential = rand.potential,
                     importBlocks = FALSE, shuffle.type = 0, 
                     popLevelOut = TRUE, parallel = FALSE) #no blocking

socEdges <- socialEdges(x = CC1[[1]], alpha = 0.05, weight = NULL, 
                     removeDuplicates = TRUE)

   }
}
\keyword{network-analysis}
\keyword{social-network}
