% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-atomic.R
\name{opts_atomic}
\alias{opts_atomic}
\title{Constructive options for atomic types}
\usage{
opts_atomic(
  ...,
  trim = NULL,
  fill = c("default", "rlang", "+", "...", "none"),
  compress = TRUE,
  unicode_representation = c("ascii", "latin", "character", "unicode"),
  escape = FALSE
)
}
\arguments{
\item{...}{Should not be used. Forces passing arguments by name.}

\item{trim}{\code{NULL} or integerish. Maximum of elements showed before it's trimmed.
Note that it will necessarily produce code that doesn't reproduce the input.
This code will parse without failure but its evaluation might fail.}

\item{fill}{String. Method to use to represent the trimmed elements.}

\item{compress}{Boolean. It \code{TRUE} instead of \code{c()} Use \code{seq()}, \code{rep()}, or atomic constructors \code{logical()}, \code{integer()},
\code{numeric()}, \code{complex()}, \code{raw()} when relevant to simplify the output.}

\item{unicode_representation}{By default "ascii", which means only ASCII characters
(code point < 128) will be used to construct a string. This makes sure that
homoglyphs (different spaces and other identically displayed unicode characters)
are printed differently, and avoid possible unfortunate copy and paste
auto conversion issues. "latin" is more lax and uses all latin characters
(code point < 256). "character" shows all characters, but not emojis. Finally
"unicode" displays all characters and emojis, which is what \code{dput()} does.}

\item{escape}{Whether to escape double quotes and backslashes. If \code{FALSE} we use
single quotes to suround strings containing double quotes, and raw strings
for strings that contain backslashes and/or a combination of single and
double quotes. Depending on \code{unicode_representation} \code{escape = FALSE} cannot be applied
on all strings.}
}
\value{
An object of class <constructive_options/constructive_options_atomic>
}
\description{
These options will be used on atomic types ("logical", "integer", "numeric", "complex", "character" and "raw")
}
\details{
If \code{trim} is provided, depending on \code{fill} we will present trimmed elements as followed:
\itemize{
\item \code{"default"} : Use default atomic constructors, so for instance \code{c("a", "b", "c")} might become \code{c("a", character(2))}.
\item \code{"rlang"} : Use rlang atomic constructors, so for instance \code{c("a", "b", "c")} might become \code{c("a", rlang::new_character(2))},
these \code{rlang} constructors create vectors of \code{NAs}, so it's different from the default option.
\item \code{"+"}: Use unary \code{+}, so for instance \code{c("a", "b", "c")} might become \code{c("a", +2)}.
\item \code{"..."}: Use \code{...}, so for instance \code{c("a", "b", "c")} might become \code{c("a", ...)}
\item \code{"none"}: Don't represent trimmed elements.
}

Depending on the case some or all of the choices above might generate code that
cannot be executed. The 2 former options above are the most likely to suceed
and produce an output of the same type and dimensions recursively. This would
at least be the case for data frame.
}
\examples{
construct(iris, opts_atomic(trim = 2), check = FALSE) # fill = "default"
construct(iris, opts_atomic(trim = 2, fill = "rlang"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "+"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "..."), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "none"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "none"), check = FALSE)
x <- c("a a", "a\U000000A0a", "a\U00002002a", "\U430 \U430")
construct(x, opts_atomic(unicode_representation = "unicode"))
construct(x, opts_atomic(unicode_representation = "character"))
construct(x, opts_atomic(unicode_representation = "latin"))
construct(x, opts_atomic(unicode_representation = "ascii"))
}
