% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lr.R
\name{lr}
\alias{lr}
\title{Likelihood Ratio Chi-square (LR)}
\usage{
lr(observed, expected)
}
\arguments{
\item{observed}{a vector giving the observed frequencies.}

\item{expected}{a vector giving the expected frequencies.}
}
\value{
numeric giving the likelihood ratio chi-square statistic.
}
\description{
Calculates the likelihod ratio chi-square statistic based on observed and expected counts.
}
\details{
No details in the moment.
}
\examples{
#######################################
######### some examples ########
data(newborns)
newborns
designmatrix <- design_cfg_cfa(kat=c(2,2)) # generate an designmatrix (only main effects)
observed <- newborns[,3] # extract observed counts
expected <- expected_cfa(des=designmatrix, observed=observed) # calculation of expected counts
lr(observed,expected) # calculation of the likelihood ratio chi-square statistic
}
\references{
Stemmler, M. (2014). \emph{Person-Centered Methods -- Configural Frequency Analysis (CFA) and Other Methods for the Analysis of Contingency Tables}. Cham Heidelberg New York Dordrecht London: Springer.
}

