% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space.R
\name{confl_space}
\alias{confl_space}
\alias{confl_list_spaces}
\alias{confl_get_space}
\title{REST Wrapper for the SpaceService}
\usage{
confl_list_spaces(
  spaceKey = NULL,
  type = c("global", "personal"),
  status = c("current", "archived"),
  label = NULL,
  favourite = NULL,
  expand = NULL,
  start = NULL,
  limit = 25
)

confl_get_space(spaceKey, expand = NULL)
}
\arguments{
\item{spaceKey}{The space key to find content under.}

\item{type}{Filter the list of spaces returned by type (\code{global}, \code{personal}).}

\item{status}{Filter the list of spaces returned by status (\code{current}, \code{archived}).}

\item{label}{Filter the list of spaces returned by label.}

\item{favourite}{Filter the list of spaces returned by favourites.}

\item{expand}{A comma separated list of properties to expand. To refer the nested
contents, use periods. (e.g. \verb{body.storage,history}).}

\item{start}{The start point of the collection to return.}

\item{limit}{The limit of the number of items to return, this may be restricted by fixed system limits.}
}
\value{
The API response as a list.
}
\description{
REST Wrapper for the SpaceService
}
\examples{
\dontrun{
# Get the information of a space named "space1"
confl_get_space("space1")
}

}
