% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidenceCurves.R
\name{makeConfidenceCurves}
\alias{makeConfidenceCurves}
\title{Frequentist confidence analysis for any treatment effect}
\usage{
makeConfidenceCurves(
  theta.estimator = NULL,
  estimator.type = NULL,
  treat.var = NULL,
  standard.error = NULL,
  confidence.lower = NULL,
  confidence.upper = NULL,
  sample.size = NULL,
  num.resp.ctrl = NULL,
  num.resp.trmt = NULL,
  num.ctrl = NULL,
  num.trmt = NULL,
  directory = "",
  show = "BENEFIT",
  pval = "TWO-SIDED",
  min.effect = -0.05,
  neutral.effect = 0,
  dir.benefit = 0,
  dir.min.effect = NULL,
  equiv = NULL,
  save.plot = FALSE,
  return.plot = FALSE,
  tag = ""
)
}
\arguments{
\item{theta.estimator}{Enter the point estimate, assumed to follow a Normal distribution.}

\item{estimator.type}{when entering binary data into inputs, specify "risk difference" or "odds ratio". For "odds ratio" option, the log odds with be used.}

\item{treat.var}{Variance associated with the point estimate. Must be supplied with sample size.}

\item{standard.error}{Standard error associated with the point estimate.}

\item{confidence.lower}{Lower boundary of 95\% confidence interval.}

\item{confidence.upper}{Upper boundary of 95\% confidence interval.}

\item{sample.size}{Sample size. Can be calculated from num.ctrl and num.trmt.}

\item{num.resp.ctrl}{When specifying binary input data; Number of responders in control group (who experienced the outcome).}

\item{num.resp.trmt}{When specifying binary input data; Number of responders in treatment group (who experienced the outcome).}

\item{num.ctrl}{When specifying binary input data; Number of subjects in the control group.}

\item{num.trmt}{When specifying binary input data; Number of subjects in the treatment group.}

\item{directory}{Character string expressing directory where you want to save the confidence curve family. Default is "".}

\item{show}{On the confidence density function, which region to display in shaded blue: BENEFIT' (default), 'LMB' (lack of meaningful benefit),
'MB' (meaningful benefit) or 'EQUIV' (equivalence).}

\item{pval}{Specify "ONE-SIDED" or "TWO_SIDED" test for returned p-value. Default is "TWO-SIDED".}

\item{min.effect}{The minimally clinically interesting effect (meaningful benefit). Default is -0.05.}

\item{neutral.effect}{Value corresponding to no effect. Default is 0. If using odds ratio, data should be on the log scale for a neutral effect of 0.}

\item{dir.benefit}{Direction (0 or 1) around the neutral effect corresponding to benefit. 0: less than no effect value (default); 1: more than no effect value.}

\item{dir.min.effect}{Direction (0 or 1) around the min effect that you're interested in. 0: less than min effect value; 1: more than min effect value. Default assumes LACK of meaningful benefit.}

\item{equiv}{If interested in expressing confidence in treatment equivalence, you can specify
two numbers as c(a,b) to bound the equivalency region. Default uses min.effect and -min.effect as a and b}

\item{save.plot}{save the plot as png to directory, TRUE or FALSE (default).}

\item{return.plot}{Return the plots from the function, TRUE or FALSE (default).}

\item{tag}{phrase to append to the image filename as <directory>/confidence_curves_<tag>.png. Default is "".}
}
\value{
Returns a list of values associated with confidence analysis (under $text) and (if supplied TRUE to return.plot) four confidence curves
}
\description{
This function performs frequentist confidence analysis, given a point estimate and associated error estimation, to answer the question:
How much confidence can we have in a particular treatment effect of interest?
}
\details{
This is a function to perform frequentist confidence analysis on a observed treatment estimate. You may either supply a point estimate and associated precision estimate
via standard error, variance and sample size, and 95\% CI interval, or enter outcome data directly (the latter option is only available for binary data). Then, define a neutral effect,
and a meaningful clinical effect, and the direction of interest (above or below these) and the function will calculate how much confidence one can have in the associated treatment effect (e.g., beneficial, lacking meaningful benefit).
Also returned is the traditional frequentist p-value.
}
\examples{
makeConfidenceCurves(
theta.estimator = -0.22,
confidence.lower = -0.36,
confidence.upper = -0.07
)
}
\references{
Equations used in this function are derived from Marschner, I. "Confidence distributions for treatment effects in Clinical Trials: Posteriors without Priors", Statistics in Medicine, 2024;43:1271-1289.
}
