% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_diverging.R
\name{scale_colour_discrete_diverging}
\alias{scale_colour_discrete_diverging}
\alias{scale_color_discrete_diverging}
\alias{scale_fill_discrete_diverging}
\title{HCL-Based Discrete Diverging Color Scales for ggplot2}
\usage{
scale_colour_discrete_diverging(palette = NULL, c1 = NULL,
  cmax = NULL, l1 = NULL, l2 = NULL, h1 = NULL, h2 = NULL,
  p1 = NULL, p2 = NULL, alpha = 1, rev = FALSE, nmax = NULL,
  order = NULL, aesthetics = "colour", ...)

scale_color_discrete_diverging(palette = NULL, c1 = NULL,
  cmax = NULL, l1 = NULL, l2 = NULL, h1 = NULL, h2 = NULL,
  p1 = NULL, p2 = NULL, alpha = 1, rev = FALSE, nmax = NULL,
  order = NULL, aesthetics = "colour", ...)

scale_fill_discrete_diverging(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "diverging")} for available options.}

\item{c1}{Chroma value at the scale endpoints.}

\item{cmax}{Maximum chroma value.}

\item{l1}{Luminance value at the scale endpoints.}

\item{l2}{Luminance value at the scale midpoint.}

\item{h1}{Hue value at the first endpoint.}

\item{h2}{Hue value at the second endpoint.}

\item{p1}{Control parameter determining how chroma should vary (1 = linear, 2 = quadratic, etc.).}

\item{p2}{Control parameter determining how luminance should vary (1 = linear, 2 = quadratic, etc.).}

\item{alpha}{Numeric vector of values in the range \code{[0, 1]} for alpha transparency channel (0 means transparent and 1 means opaque).}

\item{rev}{If \code{TRUE}, reverses the order of the colors in the color scale.}

\item{nmax}{Maximum number of different colors the palette should contain. If not provided, is calculated automatically
from the data.}

\item{order}{Numeric vector listing the order in which the colors should be used. Default is \code{1:nmax}.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{...}{common discrete scale parameters: \code{name}, \code{breaks}, \code{labels}, \code{na.value}, \code{limits} and \code{guide}. See
\code{\link[ggplot2]{discrete_scale}} for more details.}
}
\description{
Discrete ggplot2 color scales using the color palettes generated by \code{\link{diverging_hcl}}.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.
}
\examples{
library(ggplot2)

# default colors with slightly darkened midpoint
ggplot(iris, aes(Sepal.Length, Sepal.Width, color = Species)) +
  geom_point() + theme_minimal() + 
  scale_color_discrete_diverging(l2=75)

# color scale "Green-Orange"
ggplot(iris, aes(Sepal.Length, fill = Species)) +
  geom_density(alpha = 0.7) + theme_classic() +
    scale_fill_discrete_diverging(palette = "Green-Orange", rev = TRUE)
    
# use `nmax` and `order` to skip some colors
ggplot(iris, aes(Sepal.Length, fill = Species)) +
  geom_density(alpha = 0.7) + theme_classic() +
    scale_fill_discrete_diverging(palette = "Green-Orange", nmax = 5, order = c(1, 4, 5))
}
