% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{legend_set}
\alias{legend_set}
\title{Make an HCL legend for an unordered set of distributions}
\usage{
legend_set(
  palette,
  specificity = TRUE,
  group_labels = NULL,
  label_i = "Maximum\\nintensity",
  label_s = "Specificity",
  axis_i = c("low", "high"),
  axis_s = c("low", "high"),
  return_df = FALSE
)
}
\arguments{
\item{palette}{data frame containing a color palette generated by
\link{palette_set}.}

\item{specificity}{logical indicating whether to visualize intensity and
layer information for the full range of potential specificity values (i.e.,
0-100) or for a single specificity value (i.e., 100). Typically, a single
specificity value is appropriate for \link{map_multiples} visualizations.}

\item{group_labels}{(axis_l) character vector with labels for each distribution.}

\item{label_i}{character vector with a single element describing the meaning
of specificity.}

\item{label_s}{character vector with a single element describing the meaning
of intensity values.}

\item{axis_i}{character vector with two elements describing the meaning of
low and high intensity values.}

\item{axis_s}{character vector with two elements describing the meaning of
low and high specificity values.}

\item{return_df}{logical indicating whether to return the legend as a
\code{ggplot2} object or return a data frame containing the necessary data to
build the legend.}
}
\value{
A \code{ggplot2} plot object of the legend. Alternatively,
\code{return_df = TRUE} will return a data frame containing a data frame
containing the data needed to build the legend. The data frame columns are:
\itemize{
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
\item \code{intensity}: maximum cell value across layers divided by the maximum
value across all layers and cells; mapped to alpha level.
}
}
\description{
This function creates a legend to accompany a map describing
an unordered set of distributions.
}
\examples{
# load elephant data
data(elephant_ud)

# generate hcl palette
pal <- palette_set(elephant_ud)

# create legend for palettes
legend_set(pal)
}
\seealso{
\link{legend_timecycle} for cyclical sequences of distributions and
\link{legend_timeline} for linear sequences of distributions.

Other legend: 
\code{\link{legend_timecycle}()},
\code{\link{legend_timeline}()}
}
\concept{legend}
