% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional.R
\name{nform}
\alias{nform}
\title{Helper function to adjust LD parameter r for differential sample size between snps}
\usage{
nform(n0a, n1a, n0b, n1b, n0ab = pmin(n0a, n0b), n1ab = pmin(n1a, n1b))
}
\arguments{
\item{n0a}{number of controls with data at snp a}

\item{n1a}{number of cases with data at snp a}

\item{n0b}{number of controls with data at snp b}

\item{n1b}{number of cases with data at snp b}

\item{n0ab}{number of controls with data at both snps a and b}

\item{n1ab}{number of cases with data at both snps a and b}
}
\value{
proportionality constant that depends on sample size.
}
\description{
Estimate the r between effect estimates at snps which were
genotyped on different sets of cases and controls.  The adjusted r
will be nform(...) * r (where r is the population correlation
between snps).
}
