% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_methods.R
\name{f_v}
\alias{f_v}
\title{Association Between a Categorical Response and a Categorical Predictor}
\usage{
f_v(df)
}
\arguments{
\item{df}{(required, data frame) with columns:
\itemize{
\item "x": (character or factor) categorical predictor.
\item "y": (character or factor) categorical response.
}}
}
\value{
numeric: Cramer's V
}
\description{
Computes Cramer's V, a measure of association between categorical or factor variables. Please see \code{\link[=cor_cramer_v]{cor_cramer_v()}} for further details.
}
\examples{
#load example data
data(vi)

#reduce size to speed-up example
vi <- vi[1:1000, ]

#categorical response and predictor
#to data frame without NAs
df <- data.frame(
  y = vi[["vi_factor"]],
  x = vi[["soil_type"]]
) |>
  na.omit()

#Cramer's V
f_v(df = df)
}
\seealso{
Other preference_order_functions: 
\code{\link{f_auc}},
\code{\link{f_r2}},
\code{\link{f_r2_counts}},
\code{\link{f_v_rf_categorical}()}
}
\concept{preference_order_functions}
