% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order_methods.R
\name{f_auto}
\alias{f_auto}
\title{Select Function to Compute Preference Order}
\usage{
f_auto(df = NULL, response = NULL, predictors = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{response}{(optional; character string or vector) Name/s of response variable/s in \code{df}. Used in target encoding when it names a numeric variable and there are categorical predictors, and to compute preference order. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
function name
}
\description{
Internal function to select a proper f_...() function to compute preference order depending on the types of the response variable and the predictors. The selection criteria is available as a data frame generated by \code{\link[=f_auto_rules]{f_auto_rules()}}.
}
\examples{
f <- f_auto(
  df = vi[1:1000, ],
  response = "vi_numeric",
  predictors = vi_predictors_numeric
  )
}
\seealso{
Other preference_order_tools: 
\code{\link{f_auto_rules}()},
\code{\link{f_functions}()},
\code{\link{preference_order_collinear}()}
}
\concept{preference_order_tools}
