% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_PHMM.r
\name{subsetPHMM}
\alias{subsetPHMM}
\title{Subset an existing PHMM.}
\usage{
subsetPHMM(x, start, end)
}
\arguments{
\item{x}{an object of class \code{"PHMM"} to be subset.}

\item{start}{The first PHMM position to be inclused in the output PHMM.}

\item{end}{The last PHMM position to be included in the output PHMM.}
}
\value{
an object of class \code{"PHMM"}
}
\description{
The \code{subsetPHMM} function allows an existing PHMM to be subset
by profile position. This eliminates the need for the training of an additional, smaller
model if query sequences should be compared to only a subsection of an existing PHMM.
The nt_coi_PHMM and aa_coi_PHMM can therefore be subset using this function to constrain
coil's framing and error evaluation to a subset of the COI-5P region
}
\examples{
## subset positions 2-100 of the COI-5P PHMM
short_nt_PHMM <- subsetPHMM(nt_coi_PHMM, 2, 100)
}
\seealso{
\code{\link{derivePHMM}}
}
