% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort_methods.R, R/source_methods.R
\name{add_step}
\alias{add_step}
\alias{add_step.Cohort}
\alias{add_step.Source}
\title{Add filtering step definition}
\usage{
add_step(x, step, ...)

\method{add_step}{Cohort}(
  x,
  step,
  run_flow = FALSE,
  hook = list(pre = get_hook("pre_add_step_hook"), post = get_hook("post_add_step_hook")),
  ...
)

\method{add_step}{Source}(x, step, ...)
}
\arguments{
\item{x}{An object to add step to.}

\item{step}{Step definition created with \link{step}.}

\item{...}{Other parameters passed to specific S3 method.}

\item{run_flow}{If `TRUE`, data flow is run after the step is added.}

\item{hook}{List of hooks describing methods to run before/after the step is added.
See \link{hooks} for more details.}
}
\value{
Method dependent object (i.e. `Cohort` or `Source`) having new step added.
}
\description{
Add filtering step definition
}
\seealso{
\link{managing-cohort}, \link{managing-source}
}
