% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pcoga2dim_diff_shape}
\alias{pcoga2dim_diff_shape}
\title{Recurrence Identity of Shape Parameter for \code{pcoga2dim}}
\usage{
pcoga2dim_diff_shape(x, shape1, shape2, rate1, rate2)
}
\arguments{
\item{x}{Quantiles.}

\item{shape1, shape2}{Shape parameters of the first and second gamma
distributions, both shape parameters should be larger than or equal to 0.}

\item{rate1, rate2}{Rate parameters of the first and second gamma
distributions, both rate parameters should be larger than 0.}
}
\description{
The difference of distribution functions of convolution of two gamma
distributions between consecutive neighbors of shape parameter. This
function evaluate the value of 'pcoga2dim(x, shape1, shape2, rate1, rate2)
- pcoga2dim(x, shape1 + 1, shape2, rate1, rate2)' with higher efficiency
(this function is much more faster than call \code{pcoga2dim} two-times).
}
\examples{
## these pairs give us the same results
pcoga2dim_diff_shape(3,2,4,5,4)
pcoga2dim(3,2,4,5,4) - pcoga2dim(3,3,4,5,4)

pcoga2dim_diff_shape(3,0,4,3,5)
pgamma(3,4,5) - pcoga2dim(3,1,4,3,5)

pcoga2dim_diff_shape(3,6,0,5,4)
pgamma(3,6,5) - pgamma(3,7,5)

pcoga2dim_diff_shape(3,0,0,4,5)
1 - pgamma(3,1,4)

}
\author{
Chaoran Hu
}
