% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPlotPlotly.r
\name{buildPlottingPloty.default}
\alias{buildPlottingPloty.default}
\title{buildPlottingPloty.default}
\usage{
buildPlottingPloty.default(
  modelCI,
  title = "Coefficient Plot",
  xlab = "Value",
  ylab = "Coefficient",
  lwdInner = 3,
  lwdOuter = 1,
  color = "blue",
  shape = "circle",
  pointSize = 8
)
}
\arguments{
\item{modelCI}{An object created by \code{\link{buildModelCI}}}

\item{title}{The name of the plot, if NULL then no name is given}

\item{xlab}{The x label}

\item{ylab}{The y label}

\item{lwdInner}{The thickness of the inner confidence interval}

\item{lwdOuter}{The thickness of the outer confidence interval}

\item{color}{The color of the points and lines}

\item{shape}{The shape of the points}

\item{pointSize}{Size of coefficient point}
}
\value{
a ggplot graph object
}
\description{
Builds the plotting structure for interactive coefplots
}
\details{
Uses plotly to make an interactive version of coefplot. Still uses modelCI.
}
\examples{

data(diamonds)
mod1 <- lm(price ~ carat + cut, data=diamonds)
theCI1 <- coefplot:::buildModelCI(mod1)
coefplot:::buildPlottingPloty.default(theCI1)
coefplot(mod1, interactive=TRUE)
mod2 <- lm(mpg ~ cyl + qsec - 1, data=mtcars)
mod3 <- lm(mpg ~ cyl + qsec + disp - 1, data=mtcars)
theCI2 <- coefplot:::buildModelCI(mod2)
theCI3 <- coefplot:::buildModelCI(mod3)
coefplot::buildPlottingPloty.default(theCI2)
coefplot::buildPlottingPloty.default(theCI3)
coefplot(mod2, interactive=TRUE)
coefplot(mod3, interactive=TRUE)

mod4 <- glmnet::glmnet(
x=as.matrix(diamonds[, c('carat', 'x', 'y', 'z')]),
y=diamonds$price
)
coefplot(mod4, interactive=TRUE, lambda=0.65)

}
\seealso{
\code{\link{coefplot.default}} \code{\link{coefplot}} \code{\link{buildPlotting.default}}
}
\author{
Jared P. Lander
}
