% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_summary.R
\name{format_summary}
\alias{format_summary}
\alias{format_mean}
\alias{format_meanci}
\alias{format_meanse}
\alias{format_meansd}
\alias{format_median}
\alias{format_medianiqr}
\title{Calculate and format summary statistics of central tendency and error}
\usage{
format_summary(
  x = NULL,
  tendency = "mean",
  error = "ci",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "limits",
  cilevel = 0.95,
  errorlabel = TRUE,
  type = "md"
)

format_mean(
  x = NULL,
  tendency = "mean",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "none",
  type = "md"
)

format_meanci(
  x = NULL,
  tendency = "mean",
  error = "ci",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "limits",
  cilevel = 0.95,
  errorlabel = TRUE,
  type = "md"
)

format_meanse(
  x = NULL,
  tendency = "mean",
  error = "se",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "par",
  errorlabel = TRUE,
  type = "md"
)

format_meansd(
  x = NULL,
  tendency = "mean",
  error = "sd",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "par",
  errorlabel = TRUE,
  type = "md"
)

format_median(
  x = NULL,
  tendency = "median",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "none",
  type = "md"
)

format_medianiqr(
  x = NULL,
  tendency = "median",
  error = "iqr",
  values = NULL,
  digits = 1,
  tendlabel = "abbr",
  italics = TRUE,
  subscript = NULL,
  units = NULL,
  display = "par",
  errorlabel = TRUE,
  type = "md"
)
}
\arguments{
\item{x}{Numeric vector of data to calculate mean and error}

\item{tendency}{Character vector specifying measure of central
tendency ("mean" = mean, "median" = median)}

\item{error}{Character vector specifying error type ("ci" = confidence
interval, "se" = standard error of the mean, "sd" = standard deviation, "iqr"
= interquartile range)}

\item{values}{Numeric vector of mean and interval or mean and lower and upper
limits}

\item{digits}{Number of digits after the decimal for means and error}

\item{tendlabel}{Formatting for tendency label ("abbr" = M, "word" = Mean,
"none" = no label)}

\item{italics}{Logical value (default = TRUE) for whether mean label should
be italicized}

\item{subscript}{Character string to include as subscript with mean label}

\item{units}{Character string that gives units to include after mean value}

\item{display}{Character vector specifying how to display error ("limits" =
[lower limit, upper limit], "pm" = ±interval, "par" = (interval), "none" =
do not display error)}

\item{cilevel}{Numeric scalar from 0-1 defining confidence level
(defaults to 0.95)}

\item{errorlabel}{Logical value (default = TRUE) for whether error label (e.g., 95\% CI) should be
included}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX)}
}
\value{
A character string of mean and error formatted in Markdown or LaTeX.
To return only the mean (no error), set \code{display = "none"}.
}
\description{
\code{format_summary()} is a general function that allows you to either
automatically calculate mean/median and a measure of error from a data vector
or specify already calculated a mean/median and either an error interval or
error limits. Error measures include confidence intervals, standard
deviation, and standard error of the mean. Each of those has a specific
function that formats means and those error measures using APA (7th edition)
style. So \code{\link[=format_meanci]{format_meanci()}}, \code{\link[=format_meansd]{format_meansd()}}, \code{\link[=format_meanse]{format_meanse()}}, and
\code{\link[=format_medianiqr]{format_medianiqr()}} are wrappers around \code{\link[=format_summary]{format_summary()}} for specific
error measures with a default style. To just format the mean or median with
no error, use \code{\link[=format_mean]{format_mean()}} or \code{\link[=format_median]{format_median()}}. All measures ignore NAs.
}
\examples{
# Print mean and 95\% confidence limits for fuel efficiency
format_meanci(mtcars$mpg)

# Print mean and standard deviation
format_meansd(mtcars$mpg)

# Print mean and standard error of the mean
format_meanse(mtcars$mpg)

# Print mean
format_mean(mtcars$mpg)

# Print mean and 95\% confidence limits with no label for "95\% CI"
format_meanci(mtcars$mpg, errorlabel = FALSE)

# Print mean and standard error of the mean as plus/minus interval
format_meanse(mtcars$mpg, error = "se", display = "pm")

# Print mean and 90\% confidence limits with units
format_meanci(mtcars$mpg, units = "cm", cilevel = 0.9)

# Print three-digit mean with subscript in LaTeX
format_summary(mtcars$mpg, digits = 3, subscript = "control", display = "none", type = "latex")
}
