% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFunctions.R
\name{getDesignMatrix}
\alias{getDesignMatrix}
\title{Create an efficient design matrix based on a list of aspect models}
\usage{
getDesignMatrix(model.list, data)
}
\arguments{
\item{model.list}{a list of formulas, one for each source of nonstationarity, specifying the
models.}

\item{data}{a data.frame}
}
\value{
a list() with two elements: a design matrix of dimension
(n x p), and a par.pos object, indexing columns of the design matrix refered
to each aspect models.
}
\description{
Creates a unique design matrix based on model specification for
each of the different potentially spatially varying aspects.
}
\examples{
model.list <- list(   "mean" = 0,
                      "std.dev" = as.formula(" ~ 1 + lati_s * long_s"),
                      "scale" = as.formula(" ~ 1 + elev_s"),
                      "aniso" = as.formula(" ~ 1 + elev_s"),
                      "tilt" = as.formula(" ~ 1 + elev_s"),
                      "smooth" = as.formula(" ~ 1"),
                      "nugget" = -Inf)
                      
}
\author{
Federico Blasi
}
