% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{pdf_gomp}
\alias{pdf_gomp}
\title{Compute the PDF of the Gompertz Distribution}
\usage{
pdf_gomp(x, alpha, beta)
}
\arguments{
\item{x}{A numeric vector of non-negative input values (e.g., failure times).}

\item{alpha}{A positive numeric value representing the shape parameter.}

\item{beta}{A positive numeric value representing the scale parameter.}
}
\value{
A numeric vector of the PDF values for each input in \code{x}.
}
\description{
Calculates the probability density function (PDF) of the Gompertz distribution
for given input values and parameters.
}
\details{
The PDF provides the relative likelihood of a failure or event occurring at specific time points.
Ensure that \code{alpha} and \code{beta} are positive for meaningful results.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
x <- c(1, 2, 3)
alpha <- 0.5
beta <- 0.1
lapply(x, pdf_gomp, alpha = alpha, beta = beta) |> unlist()
}
