% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{estimate_parameters}
\alias{estimate_parameters}
\title{Estimate Model Parameters Using Optimization}
\usage{
estimate_parameters(initial_params = rep(0.01, 4), optimMethod = 'BFGS')
}
\arguments{
\item{initial_params}{A numeric vector of initial parameter values to start the optimization.
Default is a vector of four values, all set to 0.01.}

\item{optimMethod}{A character string specifying the optimization method to use.
The default is \code{"BFGS"}. See \code{?optim} for a list of available methods.}
}
\value{
An \code{optim} object containing the optimization results, including the estimated
parameters, value of the objective function at the optimum, and other optimization details.
}
\description{
This function estimates the parameters of a model by minimizing the negative
log-likelihood function using the specified optimization method. It utilizes
the \code{optim()} function in R, with the provided initial parameter values and
gradient computation. The optimization method can be specified, with "BFGS" being
the default.
}
\details{
The \code{estimate_parameters} function performs parameter estimation by minimizing
the negative log-likelihood function using the chosen optimization method. The function
requires an initial guess for the parameters (a numeric vector) and will optimize the
log-likelihood function. The optimization also takes into account the gradient of the
log-likelihood function, which is computed using the \code{compute_grad} function. The result
of the optimization is an object of class \code{optim} containing the estimated parameters and
other details of the optimization process.

The optimization method can be specified via the \code{optimMethod} argument. The default method
is "BFGS", but any method supported by R's \code{optim()} function (such as "Nelder-Mead", "CG", etc.)
can be used.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
# Estimate model parameters using default initial values and the BFGS method
result <- estimate_parameters()
print(result)

}
\seealso{
\link[stats:optim]{stats::optim} for more details on optimization methods and usage.
}
