% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_standardizeHeights}
\alias{comparison_standardizeHeights}
\title{Standardize height values of a scan by centering/scaling by desired statistics
and replacing missing values}
\usage{
comparison_standardizeHeights(
  heightValues,
  withRespectTo = "individualCell",
  centerBy = mean,
  scaleBy = sd
)
}
\arguments{
\item{heightValues}{list/tibble column of x3p objects}

\item{withRespectTo}{currently ignored}

\item{centerBy}{statistic by which to center (i.e., subtract from) the height
values}

\item{scaleBy}{statistic by which to scale (i.e., divide) the height values}
}
\value{
A list of the same length as the input containing x3p objects with
standardized surface matrices
}
\description{
Standardize height values of a scan by centering/scaling by desired statistics
and replacing missing values
}
\note{
this function adds information to the metainformation of the x3p scan it
is given that is required for calculating, for example, the
pairwise-complete correlation using the comparison_cor function.
}
\examples{

data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = 64) \%>\%
dplyr::mutate(regionHeightValues = comparison_getTargetRegions(cellHeightValues = cellHeightValues,
                                                               target = fadul1.2_processed)) \%>\%
dplyr::mutate(cellPropMissing = comparison_calcPropMissing(heightValues = cellHeightValues),
              regionPropMissing = comparison_calcPropMissing(heightValues = regionHeightValues)) \%>\%
dplyr::filter(cellPropMissing <= .85 & regionPropMissing <= .85) \%>\%
dplyr::mutate(cellHeightValues = comparison_standardizeHeights(heightValues = cellHeightValues),
             regionHeightValues = comparison_standardizeHeights(heightValues = regionHeightValues))

head(cellTibble)

}
