% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-countClinData.R
\name{plotCountClinData}
\alias{plotCountClinData}
\title{Interactive plot of 'count' data}
\usage{
plotCountClinData(
  data,
  vars,
  varsLab = getLabelVar(vars, labelVars = labelVars),
  valueVar,
  valueLab = getLabelVar(valueVar, labelVars = labelVars),
  colorVar = NULL,
  colorLab = getLabelVar(valueVar, labelVars = labelVars),
  colorPalette = getOption("clinDataReview.colors"),
  colorRange = NULL,
  valueType = "total",
  titleExtra = NULL,
  title = paste(paste(valueLab, "by", paste(varsLab, collapse = " and "), titleExtra),
    collapse = "<br>"),
  subtitle = NULL,
  caption = NULL,
  labelVars = NULL,
  width = NULL,
  height = NULL,
  pathVar = NULL,
  pathLab = getLabelVar(pathVar, labelVars = labelVars),
  hoverVars = c(vars, valueVar, colorVar),
  hoverLab = getLabelVar(hoverVars, labelVars = labelVars),
  table = FALSE,
  tableVars,
  tableLab,
  tableButton = TRUE,
  tablePars = list(),
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  verbose = FALSE,
  typePlot = c("sunburst", "treemap")
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{vars}{Character vector with variables of \code{data}
containing the groups. If multiple, they should be specified in 
hierarchical order (from parent to child node).}

\item{varsLab}{Named character vector with labels for \code{vars}.}

\item{valueVar}{String with numeric variable of \code{data} 
containing the value to display.}

\item{valueLab}{String with label for the \code{valueVar} variable.}

\item{colorVar}{(optional) String with coloring variable
(NULL by default).
By default, the treemap is colored based by section.}

\item{colorLab}{String with label for \code{colorVar}.}

\item{colorPalette}{(optional) Named character vector with color palette.
If not specified, the viridis color palette is used.\cr
See \code{\link[clinUtils]{clinColors}}.}

\item{colorRange}{(optional) Numeric vector of length 2 with range 
for the color variable, in case it is a numeric variable.}

\item{valueType}{String with type of values in \code{valueVar}
(\code{branchvalues} of the \code{\link[plotly]{plot_ly}}) function),
among others: 'total' (default, only if sum(child) <= to parent)
or 'relative'.}

\item{titleExtra}{String with extra title for the plot (appended after \code{title}).}

\item{title}{String with title for the plot.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{labelVars}{Named character vector containing variable labels.}

\item{width}{Numeric, width of the plot in pixels,
700 by default.}

\item{height}{Numeric, height of the plot in pixels,
700 by default.}

\item{pathVar}{String with variable of \code{data} containing hyperlinks 
with path to the subject-specific report, formatted as: \cr
\preformatted{<a href="./path-to-report">label</a>}.\cr 
If multiple, they should be separated by: ', '.\cr
The report(s) will be:
\itemize{
\item{compressed to a zip file and downloaded 
if the user clicks on the 'p' (a.k.a 'profile') key
when hovering on a point of the plot}
\item{included in a collapsible row, and clickable with hyperlinks
in the table}
}}

\item{pathLab}{String with label for \code{pathVar},
included in the collapsible row in the table.}

\item{hoverVars}{Character vector with variable(s) to be displayed in the hover,
by default any position and aesthetic variables displayed in the plot.}

\item{hoverLab}{Named character vector with labels for \code{hoverVars}.}

\item{table}{Logical, if TRUE (FALSE by default)
returns also a \code{datatable} containing the plot data.
(The plot and the table are not linked.)}

\item{tableVars}{Character vector with variables to be included 
in the table.}

\item{tableLab}{Named character vector with labels
for each \code{tableVars}.}

\item{tableButton}{Logical, if TRUE (by default)
the table is included within an HTML button.}

\item{tablePars}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}

\item{typePlot}{String with plot type, 'treemap' or 'sunburst'.}
}
\value{
Either:
\itemize{
\item{if a \code{table} is requested: }{
a \code{clinDataReview} object, a.k.a a list with the 
'plot' (\code{\link[plotly]{plotly}} object) and 'table'
(\code{\link[DT]{datatable}} object)}
\item{otherwise: }{a \code{\link[plotly]{plotly}} object}
}
}
\description{
Note: the table and plot are not (yet) linked.
}
\seealso{
Other visualizations of summary statistics for clinical data: 
\code{\link{barplotClinData}()},
\code{\link{boxplotClinData}()},
\code{\link{errorbarClinData}()},
\code{\link{sunburstClinData}()},
\code{\link{treemapClinData}()}
}
\author{
Laure Cougnaud
}
\concept{visualizations of summary statistics for clinical data}
