% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-treemapClinData.R
\name{treemapClinData}
\alias{treemapClinData}
\title{Treemap interactive plot.}
\usage{
treemapClinData(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=plotCountClinData]{plotCountClinData}}
  \describe{
    \item{\code{colorVar}}{(optional) String with coloring variable
(NULL by default).
By default, the treemap is colored based by section.}
    \item{\code{colorLab}}{(optional) String with label for \code{colorVar}.}
    \item{\code{colorRange}}{(optional) Numeric vector of length 2 with range 
for the color variable, in case it is a numeric variable.}
    \item{\code{vars}}{Character vector with variables of \code{data}
containing plot nodes.
If multiple, they should be specified in hierarchical order (from parent to child node).}
    \item{\code{varsLab}}{Named character vector with labels for \code{vars}.}
    \item{\code{valueVar}}{String with numeric variable of \code{data} containing node value,
and associated label.}
    \item{\code{valueLab}}{String with numeric variable of \code{data} containing node value,
and associated label.}
    \item{\code{valueType}}{String with type of values in \code{valueVar}
(\code{branchvalues} of the \code{\link[plotly]{plot_ly}}) function),
among others: 'total' (default, only if sum(child) <= to parent)
or 'relative'.}
    \item{\code{pathVar}}{String with variable of \code{data} containing hyperlinks 
with path to the subject-specific report, formatted as: \cr
\preformatted{<a href="./path-to-report">label</a>}.\cr 
If multiple, they should be separated by: ', '.\cr
The report(s) will be:
\itemize{
\item{compressed to a zip file and downloaded 
if the user clicks on the 'p' (a.k.a 'profile') key
when hovering on a point of the plot}
\item{included in a collapsible row, and clickable with hyperlinks
in the table}
}}
    \item{\code{pathLab}}{String with label for \code{pathVar},
included in the collapsible row in the table.}
    \item{\code{table}}{Logical, if TRUE (FALSE by default)
returns also a \code{datatable} containing the plot data.
(The plot and the table are not linked.)}
    \item{\code{data}}{Data.frame with data.}
    \item{\code{colorPalette}}{(optional) Named character vector with color palette.
If not specified, the viridis color palette is used.\cr
See \code{\link[clinUtils]{clinColors}}.}
    \item{\code{titleExtra}}{String with extra title for the plot (appended after \code{title}).}
    \item{\code{title}}{String with title for the plot.}
    \item{\code{labelVars}}{Named character vector containing variable labels.}
    \item{\code{width}}{Numeric, width of the plot in pixels,
700 by default.}
    \item{\code{height}}{Numeric, height of the plot in pixels,
700 by default.}
    \item{\code{hoverVars}}{Character vector with variable(s) to be displayed in the hover,
by default any position and aesthetic variables displayed in the plot.}
    \item{\code{hoverLab}}{Named character vector with labels for \code{hoverVars}.}
    \item{\code{id}}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}
    \item{\code{verbose}}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}
    \item{\code{tableVars}}{Character vector with variables to be included 
in the table.}
    \item{\code{tableLab}}{Named character vector with labels
for each \code{tableVars}.}
    \item{\code{tableButton}}{Logical, if TRUE (by default)
the table is included within an HTML button.}
    \item{\code{tablePars}}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}
  }}
}
\value{
Either:
\itemize{
\item{if \code{table} is requested}{
a \code{clinDataReview} object, a.k.a a list with the 
'plot' (\code{\link[plotly]{plotly}} object) and 'table'
(\code{\link[DT]{datatable}} object)}
\item{otherwise: }{\code{\link[plotly]{plotly}} object}
}
}
\description{
Note: the table and plot are not (yet) linked.
}
\examples{
library(clinUtils)

data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

dataDM <- dataADaMCDISCP01$ADSL
dataAE <- dataADaMCDISCP01$ADAE

library(plyr)

## basic treemap:

# treemap takes as input table with counts
library(inTextSummaryTable)

# total counts: Safety Analysis Set (patients with start date for the first treatment)
dataTotal <- subset(dataDM, RFSTDTC != "")

# compute adverse event table
tableAE <- getSummaryStatisticsTable(
		
	data = dataAE,
	rowVar = c("AESOC", "AEDECOD"),
	dataTotal = dataTotal,
	rowOrder = "total",
	labelVars = labelVars,
	stats = getStats("count"),
	
	# plotly treemap requires records (rows) for each group
	rowVarTotalInclude = "AEDECOD",
	outputType = "data.frame-base"

)

dataPlot <- tableAE

dataPlot$n <- as.numeric(dataPlot$n)

# create plot
treemapClinData(
	data = dataPlot,
	vars = c("AESOC", "AEDECOD"),
	valueVar = "n",
    valueLab = "Number of patients with adverse events"
)

## treemap with coloring

# extract worst-case scenario
dataAE$AESEVN <- as.numeric(factor(dataAE$AESEV, levels = c("MILD", "MODERATE", "SEVERE")))
if(any(is.na(dataAE$AESEVN)))
	stop("Severity should be filled for all subjects.")

dataAEWC <- ddply(dataAE, c("AESOC", "AEDECOD", "USUBJID"), function(x){
	x[which.max(x$AESEVN), ]
})
dataTotalRow <- list(AEDECOD = 
	ddply(dataAEWC, c("AESOC", "USUBJID"), function(x){
		x[which.max(x$AESEVN), ]
	})
)


# compute adverse event table
tableAE <- getSummaryStatisticsTable(
		
	data = dataAEWC,
	rowVar = c("AESOC", "AEDECOD"),
	var = "AESEVN",
	dataTotal = dataTotal,
	rowOrder = "total",
	labelVars = labelVars,
		
	# plotly treemap requires records (rows) for each group
	rowVarTotalInclude = "AEDECOD",
	dataTotalRow = dataTotalRow,
	outputType = "data.frame-base"

)

dataPlot <- tableAE

dataPlot$statN <- as.numeric(dataPlot$statN)
dataPlot$statMean <- as.numeric(dataPlot$statMean)

# create plot
treemapClinData(
	data = dataPlot,
	vars = c("AESOC", "AEDECOD"),
	valueVar = "statN", valueLab = "Number of patients with adverse events",
	colorVar = "statMean", colorLab = "Mean severity"
)
}
\seealso{
Other visualizations of summary statistics for clinical data: 
\code{\link{barplotClinData}()},
\code{\link{plotCountClinData}()},
\code{\link{sunburstClinData}()}
}
\author{
Laure Cougnaud
}
\concept{visualizations of summary statistics for clinical data}
