% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlewin.R
\name{singlewin}
\alias{singlewin}
\title{Fit a single climate window}
\usage{
singlewin(xvar, cdate, bdate, baseline, range, stat, func, type, refday,
  cmissing = FALSE, cinterval = "day", cohort = NULL,
  spatial = NULL, upper = NA, lower = NA, binary = FALSE,
  centre = list(NULL, "both"), cutoff.day = NULL,
  cutoff.month = NULL, furthest = NULL, closest = NULL,
  thresh = NULL)
}
\arguments{
\item{xvar}{A list object containing all climate variables of interest. 
Please specify the parent environment and variable name (e.g. Climate$Temp).}

\item{cdate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{bdate}{The biological date variable (dd/mm/yyyy). Please specify the 
parent environment and variable name (e.g. Biol$Date).}

\item{baseline}{The baseline model structure used for testing correlation. 
Currently known to support lm, glm, lmer and glmer objects.}

\item{range}{Two values signifying respectively the furthest and closest number 
of time intervals (set by cinterval) back from the cutoff date or biological record to include 
in the climate window search.}

\item{stat}{The aggregate statistic used to analyse the climate data. Can 
currently use basic R statistics (e.g. mean, min), as well as slope. 
Additional aggregate statistics can be created using the format function(x)
(...). See FUN in \code{\link{apply}} for more detail.}

\item{func}{The functions used to fit the climate variable. Can be linear 
("lin"), quadratic ("quad"), cubic ("cub"), inverse ("inv") or log ("log").}

\item{type}{"absolute" or "relative", whether you wish the climate window to be relative
(e.g. the number of days before each biological record is measured) or absolute
(e.g. number of days before a set point in time).}

\item{refday}{If type is absolute, the day and month respectively of the 
year from which the absolute window analysis will start.}

\item{cmissing}{cmissing Determines what should be done if there are 
missing climate data. Three approaches are possible: 
 - FALSE; the function will not run if missing climate data is encountered.
 An object 'missing' will be returned containing the dates of missing climate.
 - "method1"; missing climate data will be replaced with the mean climate
 of the preceding and following 2 days.
 - "method2"; missing climate data will be replaced with the mean climate
 of all records on the same date.}

\item{cinterval}{The resolution at which climate window analysis will be 
conducted. May be days ("day"), weeks ("week"), or months ("month"). Note the units
of parameter 'range' will differ depending on the choice
of cinterval.}

\item{cohort}{A variable used to group biological records that occur in the same biological
season but cover multiple years (e.g. southern hemisphere breeding season). Only required
when type is "absolute". The cohort variable should be in the same dataset as the variable bdate.}

\item{spatial}{A list item containing:
1. A factor that defines which spatial group (i.e. population) each biological
record is taken from. The length of this factor should correspond to the length 
of the biological dataset.
2. A factor that defines which spatial group (i.e. population) climate data
corresponds to. This length of this factor should correspond to the length of
the climate dataset.}

\item{upper}{Cut-off values used to determine growing degree days or positive 
climate thresholds (depending on parameter thresh). Note that when values
of lower and upper are both provided, climatewin will instead calculate an 
optimal climate zone.}

\item{lower}{Cut-off values used to determine chill days or negative 
climate thresholds (depending on parameter thresh). Note that when values
of lower and upper are both provided, climatewin will instead calculate an 
optimal climate zone.}

\item{binary}{TRUE or FALSE. Determines whether to use values of upper and
lower to calculate binary climate data (thresh = TRUE), or to use for
growing degree days (thresh = FALSE).}

\item{centre}{A list item containing:
1. The variable used for mean centring (e.g. Year, Site, Individual). 
Please specify the parent environment and variable name (e.g. Biol$Year).
2. Whether the model should include both within-group means and variance ("both"),
only within-group means ("mean"), or only within-group variance ("dev").}

\item{cutoff.day, cutoff.month}{Redundant parameters. Now replaced by refday.}

\item{furthest, closest}{Redundant parameters. Now replaced by range.}

\item{thresh}{Redundant parameter. Now replaced by binary.}
}
\value{
Will return a list containing two objects:
 
 \itemize{
 \item BestModel, a model object of the fitted climate window
 model.
 
 \item BestModelData, a dataframe with the biological and climate data
 used to fit the climate window model.}
}
\description{
Fit a single climate window with a known start and end time.
}
\examples{

#Simple test example
#Create data from a subset of our test dataset
#Just use two years
biol_data <- Mass[1:2, ]
clim_data <- MassClimate[grep(pattern = "1979|1986", x = MassClimate$Date), ]

single <- singlewin(xvar = list(Temp = clim_data$Temp),
                   cdate = clim_data$Date, 
                   bdate = biol_data$Date, 
                   baseline = lm(Mass ~ 1, data = biol_data),
                   range = c(1, 0), 
                   type = "relative", stat = "mean", 
                   func = c("lin"), cmissing = FALSE, cinterval = "day")

\dontrun{
# Full working example
# Fit a known climate window to the datasets Mass and MassClimate

data(Mass)
data(MassClimate)

# Test for a fixed climate window, starting from 20th May
# Fit a climate window starting 72 days ago and ending 15 days ago
# Fit a linear term for the mean climate
# Fit climate windows at the resolution of days

single <- singlewin(xvar = list(Temp = MassClimate$Temp), 
                   cdate = MassClimate$Date, bdate = Mass$Date,
                   baseline = lm(Mass ~ 1, data = Mass), 
                   range = c(72, 15),
                   stat = "mean", func = "lin",
                   type = "absolute", refday = c(20, 5),
                   cmissing = FALSE, cinterval = "day")
               
##View data##
single$BestModel
head(single$BestModelData)
}

}
\author{
Liam D. Bailey and Martijn van de Pol
}
