% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripes.R
\name{ggstripes}
\alias{ggstripes}
\title{Warming stripes graph}
\usage{
ggstripes(
  data,
  plot_type = "stripes",
  plot_title = "",
  n_temp = 11,
  col_pal = "RdBu",
  ...
)
}
\arguments{
\item{data}{a data.frame with date(year) and temperature(temp) variables.}

\item{plot_type}{plot type (with labels, background, stripes with line
trend and animation). Accepted values are "background", "stripes",
"trend" or "animation".}

\item{plot_title}{character string to be used for the graph title.}

\item{n_temp}{Numeric value as the number of colors of the palette.
(default 11).}

\item{col_pal}{Character string indicating the name of the
\code{\link[=hcl.pals]{hcl.pals()}} color palette to be used for plotting.}

\item{...}{further arguments passed to \code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot different "climate stripes" or "warming stripes" using \strong{ggplot2}.
This graphics are visual representations of the change in temperature as
measured in each location over the past 70-100+ years. Each stripe
represents the temperature in that station averaged over a year.
}
\note{
"Warming stripes" charts are a conceptual idea of Professor Ed Hawkins
(University of Reading) and are specifically designed to be as simple as
possible and alert about risks of climate change. For more details see
\href{https://showyourstripes.info/}{ShowYourStripes}.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{

library(ggplot2)

data <- climaemet::climaemet_9434_temp

ggstripes(data, plot_title = "Zaragoza Airport") +
  labs(subtitle = "(1950-2020)")

ggstripes(data, plot_title = "Zaragoza Airport", plot_type = "trend") +
  labs(subtitle = "(1950-2020)")
}
\seealso{
\code{\link[=climatestripes_station]{climatestripes_station()}}, \code{\link[ggplot2:theme]{ggplot2::theme()}} for more possible
arguments to pass to \code{ggstripes}.

Other aemet_plots: 
\code{\link{climatestripes_station}()},
\code{\link{climatogram_normal}()},
\code{\link{climatogram_period}()},
\code{\link{ggclimat_walter_lieth}()},
\code{\link{ggwindrose}()},
\code{\link{windrose_days}()},
\code{\link{windrose_period}()}

Other stripes: 
\code{\link{climaemet_9434_temp}},
\code{\link{climatestripes_station}()}
}
\concept{aemet_plots}
\concept{stripes}
