% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfUser.R
\docType{class}
\name{cfUser-class}
\alias{cfUser-class}
\alias{cf_user}
\alias{cfUser}
\title{The Clifro User Object}
\usage{
cf_user(username = "public", password = character())
}
\arguments{
\item{username}{a character string to be used as the cliflo username}

\item{password}{a character string to be used as the cliflo password}
}
\value{
\code{cfUser} object
}
\description{
Create a \code{cfUser} object to allow the user to log into CliFlo from \R
and  build their query.
}
\details{
An object inheriting from the \code{cfUser} class is created by the constructor
function \code{cf_user}. The user must have an active subscription to cliflo
in order to create a valid object, unless a 'public' user is sought.
Visit \url{https://cliflo.niwa.co.nz/} for more information and to subscribe
to cliflo.
}
\note{
For the 'public' user (see examples) only the Reefton Ews station data
is available.
}
\examples{
\dontrun{
public.cfuser = cf_user(username = "public")
public.cfuser
}
}
\seealso{
\code{\link{valid_cfuser}} for details on the validation of
\code{cfUser} and \code{\link{summary,cfUser-method}} to summarise user
information.
}
