% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_interval.R
\name{gen.animation}
\alias{gen.animation}
\title{Generate animation}
\usage{
gen.animation(anim, nframes = 2 * anim$nstates, duration = anim$nstate, ...)
}
\arguments{
\item{anim}{List outputted by the \code{animate_interval()} function containing
a \code{gganim} object and  the number of states in the animation.}

\item{nframes}{Number of frames. Defaults to double the number of states
in the animation.}

\item{duration}{The duration of animation. Defaults to the number of states
in the animation.}

\item{...}{Extra arguments passed to \code{gganimate::animate()}.}
}
\value{
Does not return any value.
}
\description{
This function takes the list outputted by \code{animate_interval()} and generates
a GIF animation. It is a simple wrapper around the \code{gganimate::animate()}
function with some defaults. The generated GIF can be saved using the
\code{anim_save()} function.
}
\examples{
\dontrun{
a <- animate_interval(cts, "10 year")

# Generate animation using `gen.animation()`
gen.animation(a, height = 700, width = 900)

# Save animation using `anim_save()`
anim_save("filename.gif")
}
}
