% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postanalysis.R
\name{deptime.age}
\alias{deptime.age}
\title{Calculates the slope of a straight curve at the desired age.}
\usage{
deptime.age(age, yrcm = TRUE, prob = 0.95)
}
\arguments{
\item{age}{Age to calculate deposition time (years per cm).}

\item{yrcm}{Calculate in years per cm, or alternatively in cm per yr.}

\item{prob}{Probability level at which to calculate the ranges.}
}
\value{
Returns (invisibly) the modelled deposition times at a specific age, a histogram and confidence ranges.
}
\description{
Calculates *for each iteration* the slope of a straight curve between 
depths above and below the desired age. Requires sufficiently dense density of depths, e.g. \code{steps=1}.
}
\details{
To calculate deposition times at an age. Before doing this, run your core in clam and store the data, 
so, make sure the option \code{storedat=TRUE}.
Renamed from previous accrate.age function to avoid confusion with accrate.age function of rbacon.
}
\examples{
  clam(coredir=tempdir(), storedat=TRUE)
  dp <- deptime.age(5000)
  summary(dp)
  deptime.age(5000, yrcm=FALSE) # to calculate sedimentation times in cm/yr, so accumulation rates
}
\author{
Maarten Blaauw
}
